//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRegion.cpp
 * @brief		WXRegion t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXRegion_CPP_

//======================================================================
// include
#include "WXRegion.h"
#include <windowsx.h>
#include "../io/WXHFile.h"
#include "fnd/container/FndBuffer.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRegion::CRegion(void)
{
}

/**********************************************************************//**
 *
 * `[W̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	left	= [
 * @param [in]	top		= [
 * @param [in]	right	= E[
 * @param [in]	bottom	= [
 * @return	
*//***********************************************************************/
BOOL CRegion::CreateRect(int left, int top, int right, int bottom)
{
	HRGN hRgn = ::CreateRectRgn(left, top, right, bottom);
	return TryAttach(hRgn);
}

/**********************************************************************//**
 *
 * `[W̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lprc	= `
 * @return	
*//***********************************************************************/
BOOL CRegion::CreateRect(const LPRECT lprc)
{
	HRGN hRgn = ::CreateRectRgnIndirect(lprc);
	return TryAttach(hRgn);
}

/**********************************************************************//**
 *
 * pۋ`[W̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	left			= [
 * @param [in]	top				= [
 * @param [in]	right			= E[
 * @param [in]	bottom			= [
 * @param [in]	widthEllipse	= ۂ݂̕
 * @param [in]	heightEllipse	= ۂݍ
 * @return	
*//***********************************************************************/
BOOL CRegion::CreateRoundRect(int left, int top, int right, int bottom, int widthEllipse, int heightEllipse)
{
#if	!defined(IRIS_WIN32_WCE)
	HRGN hRgn = ::CreateRoundRectRgn(left, top, right, bottom, widthEllipse, heightEllipse);
	return TryAttach(hRgn);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pۋ`[W̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lprc			= `
 * @param [in]	widthEllipse	= ۂ݂̕
 * @param [in]	heightEllipse	= ۂݍ
 * @return	
*//***********************************************************************/
BOOL CRegion::CreateRoundRect(const LPRECT lprc, int widthEllipse, int heightEllipse)
{
	IRIS_ASSERT( lprc != nullptr );
	return CreateRoundRect(lprc->left, lprc->top, lprc->right, lprc->bottom, widthEllipse, heightEllipse);
}

/**********************************************************************//**
 *
 * ȉ~[W̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	x1	= [
 * @param [in]	y1	= [
 * @param [in]	x2	= E[
 * @param [in]	y2	= [
 * @return	
*//***********************************************************************/
BOOL CRegion::CreateElliptic(int x1, int y1, int x2, int y2)
{
#if	!defined(IRIS_WIN32_WCE)
	HRGN hRgn = ::CreateEllipticRgn(x1, y1, x2, y2);
	return TryAttach(hRgn);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * ȉ~[W̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lprc	= `
 * @return	
*//***********************************************************************/
BOOL CRegion::CreateElliptic(const LPRECT lprc)
{
#if	!defined(IRIS_WIN32_WCE)
	HRGN hRgn = ::CreateEllipticRgnIndirect(lprc);
	return TryAttach(hRgn);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * p`[W̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lppt		= _z
 * @param [in]	nPoint		= z
 * @param [in]	nFillMode	= hԂ[h
 * @return	
*//***********************************************************************/
BOOL CRegion::CreatePolygon(const LPPOINT lppt, int nPoint, int nFillMode)
{
#if	!defined(IRIS_WIN32_WCE)
	HRGN hRgn = ::CreatePolygonRgn(lppt, nPoint, nFillMode);
	return TryAttach(hRgn);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * p`[W̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lppt			= _z
 * @param [in]	lpPointCount	= _z
 * @param [in]	nCount			= z
 * @param [in]	nFillMode		= hԂ[h
 * @return	
*//***********************************************************************/
BOOL CRegion::CreatePolyPolygon(const LPPOINT lppt, const LPINT lpPointCount, int nCount, int nFillMode)
{
#if	!defined(IRIS_WIN32_WCE)
	HRGN hRgn = ::CreatePolyPolygonRgn(lppt, lpPointCount, nCount, nFillMode);
	return TryAttach(hRgn);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * Wϊf[^쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpXform			= Wϊf[^
 * @param [in]	nCount			= [Wf[^̃TCY
 * @param [in]	lpRgnData		= [Wf[^
 * @return	
*//***********************************************************************/
BOOL CRegion::CreateExt(const LPXFORM lpXform, DWORD nCount, const LPRGNDATA lpRgnData)
{
	HRGN hRgn = ::ExtCreateRegion(lpXform, nCount, lpRgnData);
	return TryAttach(hRgn);
}

/**********************************************************************//**
 *
 *@rbg}bvf[^쐬
 *
 * @note	24/32 bit [xrbg}bv̂ݑΉ
 ----------------------------------------------------------------------
 * @param [in]	hBmp		= bitmap nh
 * @param [in]	ExtColor	= ߐF
 * @return	
*//***********************************************************************/
BOOL CRegion::CreateFromBitmap(HBITMAP hBmp, COLORREF ExtColor)
{
	BITMAP bmp = {0};
	if( ::GetObject(hBmp, sizeof(BITMAP), &bmp) == 0 ) return FALSE;

	// ̃[W쐬
	if( !CreateRect(0, 0, 0, 0) ) return FALSE;

	if( bmp.bmBitsPixel < 24 )
	{
		// DIB đΉ
		// TODO : 
		return FALSE;
	}

	LPBYTE image = static_cast<LPBYTE>(bmp.bmBits);
	if( image == nullptr ) return FALSE;

	int BytesPixel = bmp.bmBitsPixel >> 3;
	for( int y=0; y < bmp.bmHeight; ++y )
	{
		image = reinterpret_cast<LPBYTE>(bmp.bmBits) + y * bmp.bmWidthBytes;
		for( int x=0; x < bmp.bmWidth; ++x, image+=BytesPixel )
		{
			if( *reinterpret_cast<LPCOLORREF>(image) != ExtColor )
			{
				int left = x;
				// As̈𓾂
				for( ++x; x < bmp.bmWidth; ++x, image+=BytesPixel )
				{
					if( *reinterpret_cast<LPCOLORREF>(image) == ExtColor ) break;
				}
				// 
				HRGN hRgn = CreateRectRgn(left, bmp.bmHeight - y, x, bmp.bmHeight - y - 1);
				if( hRgn == nullptr ) return FALSE;
				Union(hRgn);
				DeleteObject(hRgn);
			}
		}
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * t@C烍[h
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@C
 * @param [in]	lpXform			= Wϊf[^
 * @return	
*//***********************************************************************/
BOOL CRegion::Load (LPCTSTR lpszFileName, const LPXFORM lpXform)
{
#if	defined(UNICODE)
	return LoadW(lpszFileName, lpXform);
#else
	return LoadA(lpszFileName, lpXform);
#endif
}
/**
 * @ref	Load
*/
BOOL CRegion::LoadA(LPCSTR  lpszFileName, const LPXFORM lpXform)
{
	Delete();
	CHFile file;
	if( !file.OpenA(lpszFileName, "rb") ) return FALSE;
	DWORD dwSize = file.GetSize();
	DWORD dwRead = dwSize;
	fnd::CBuffer<> buf(dwSize);
	file.Read(buf, dwSize, &dwRead);
	return CreateExt(lpXform, dwRead, (LPRGNDATA)buf.ptr());
}
/**
 * @ref	Load
*/
BOOL CRegion::LoadW(LPCWSTR lpszFileName, const LPXFORM lpXform)
{
	Delete();
	CHFile file;
	if( !file.OpenW(lpszFileName, L"rb") ) return FALSE;
	DWORD dwSize = file.GetSize();
	DWORD dwRead = dwSize;
	fnd::CBuffer<> buf(dwSize);
	file.Read(buf, dwSize, &dwRead);
	return CreateExt(lpXform, dwRead, (LPRGNDATA)buf.ptr());
}

/**********************************************************************//**
 *
 * [Wf[^̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwCount		= o̓obt@TCY
 * @param [out]	lpRgnData	= o̓obt@
 * @return	݃TCYilpRgnData  nullptr ̏ꍇAKvȃobt@TCYj
*//***********************************************************************/
DWORD CRegion::GetData(DWORD dwCount, LPRGNDATA lpRgnData) const
{
	return ::GetRegionData(m_hObj, dwCount, lpRgnData);
}

/**********************************************************************//**
 *
 * r
 *
 ----------------------------------------------------------------------
 * @param [in]	hRgn	= rΏ
 * @return	
*//***********************************************************************/
BOOL CRegion::IsEqual(HRGN hRgn)	const
{
	return ::EqualRgn(m_hObj, hRgn);
}

/**********************************************************************//**
 *
 * Rs[
 *
 ----------------------------------------------------------------------
 * @param [in]	hRgn	= rΏ
 * @return	[W̕G
*//***********************************************************************/
int CRegion::Copy(HRGN hRgn)
{
	return ::CombineRgn(m_hObj, hRgn, nullptr, RGN_COPY);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hRgn	= rΏ
 * @param [in]	fMode	= [h(RGN_***)
 * @return	[W̕G
*//***********************************************************************/
int CRegion::Combine(HRGN hRgn, int fMode)
{
	return ::CombineRgn(m_hObj, m_hObj, hRgn, fMode);
}

/**********************************************************************//**
 *
 * (aW)
 *
 ----------------------------------------------------------------------
 * @param [in]	hRgn	= rΏ
 * @return	[W̕G
*//***********************************************************************/
int CRegion::Union(HRGN hRgn)
{
	return ::CombineRgn(m_hObj, m_hObj, hRgn, RGN_OR);
}

/**********************************************************************//**
 *
 * (XOR)
 *
 ----------------------------------------------------------------------
 * @param [in]	hRgn	= rΏ
 * @return	[W̕G
*//***********************************************************************/
int CRegion::Xor(HRGN hRgn)
{
	return ::CombineRgn(m_hObj, m_hObj, hRgn, RGN_XOR);
}

/**********************************************************************//**
 *
 * [W܂ލŏ̋`擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lprc	= o͋`
 * @return	[W̕G
*//***********************************************************************/
int CRegion::GetBox(LPRECT lprc)	const
{
	return ::GetRgnBox(m_hObj, lprc);
}

/**********************************************************************//**
 *
 * w肵|Cg[Wɂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= |Cg x W
 * @param [in]	y	= |Cg y W
 * @return	
*//***********************************************************************/
BOOL CRegion::IsPointIn(int x, int y)	const
{
	return ::PtInRegion(m_hObj, x, y);
}

/**********************************************************************//**
 *
 * w肵|Cg[Wɂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	x1	= [
 * @param [in]	y1	= [
 * @param [in]	x2	= E[
 * @param [in]	y2	= [
 * @return	
*//***********************************************************************/
BOOL CRegion::IsRectIn(int x1, int y1, int x2, int y2)	const
{
	RECT rc = { x1, y1, x2, y2 };
	return IsRectIn(&rc);
}

/**********************************************************************//**
 *
 * w肵|Cg[Wɂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	lprc	= [
 * @return	
*//***********************************************************************/
BOOL CRegion::IsRectIn(const LPRECT lprc)	const
{
	return ::RectInRegion(m_hObj, lprc);
}

/**********************************************************************//**
 *
 * hԂ
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	hBrush	= uV
 * @return	
*//***********************************************************************/
BOOL CRegion::Fill(HDC hdc, HBRUSH hBrush)
{
	return ::FillRgn(hdc, m_hObj, hBrush);
}

/**********************************************************************//**
 *
 * hԂ
 * foCXReLXgőIĂuVgp
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @return	
*//***********************************************************************/
BOOL CRegion::Fill(HDC hdc)
{
	return Paint(hdc);
}

/**********************************************************************//**
 *
 * hԂ
 * foCXReLXgőIĂuVgp
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @return	
*//***********************************************************************/
BOOL CRegion::Paint(HDC hdc)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::PaintRgn(hdc, m_hObj);
#else
	HBRUSH hBrush = NULL;
	hBrush = SelectBrush(hdc, hBrush);
	SelectBrush(hdc, hBrush);
	return Fill(hdc, hBrush);
#endif
}

/**********************************************************************//**
 *
 * g`
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	hBrush	= uV
 * @param [in]	w		= ̈̕
 * @param [in]	h		= ̈̍
 * @return	
*//***********************************************************************/
BOOL CRegion::Frame(HDC hdc, HBRUSH hBrush, int w, int h)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::FrameRgn(hdc, m_hObj, hBrush, w, h);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * [W̐F𔽓]
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @return	
*//***********************************************************************/
BOOL CRegion::Invert(HDC hdc)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::InvertRgn(hdc, m_hObj);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * [Ẅړ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= x ItZbgl
 * @param [in]	y	= y ItZbgl
 * @return	
*//***********************************************************************/
int CRegion::Offset(int x, int y)
{
	return ::OffsetRgn(m_hObj, x, y);
}

}	// end of namespace wx
}	// end of namespace iris
