//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIconFile.h
 * @brief		ACRt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXIconFile_H_
#define INCG_IRIS_WXIconFile_H_

//======================================================================
// include
#include "fnd/image/FndBitmap.h"
#include "fnd/memory/FndMemBuffer.h"

namespace iris {
namespace wx
{

//======================================================================
// struct
//! ACRGg[
typedef struct tagICONDIRENTRY
{
	BYTE	bWidth;			//!< sNZ
	BYTE	bHeight;		//!< sNZ
	BYTE	bColorCount;	//!< pbg(256ȏ0)
	BYTE	bReserved;		//!< reserved
	WORD	wPlanes;		//!< v[
	WORD	wBitCount;		//!< rbg[x
	DWORD	dwBytesInRes;	//!< C[WɎgpĂoCg
	DWORD	dwImageOffset;	//!< t@C̐擪̃ItZbg
} ICONDIRENTRY, *LPICONDIRENTRY;

//! ACR
#include "misc/iris_pushpack2.h"
typedef struct tagICONDIR
{
	WORD			idReserved;		//!< reserved (must be 0)
	WORD			idType;			//!< \[X^Cv
	WORD			idCount;		//!< \[X
	ICONDIRENTRY	idEntries[1];	//!< Gg[z
} ICONDIR, *LPICONDIR;
#include "misc/iris_poppack.h"

//! C[W
typedef struct tagICONIMAGE
{
	fnd::LPBMPINFOHEADER	pBmpInfo;	//!< rbg}bvwb_
	IrisRGBQUAD*			pPalette;	//!< pbgz
	BYTE*					pXOR;		//!< C[W
	BYTE*					pAND;		//!< }XN
} ICONIMAGE, *LPICONIMAGE;

//======================================================================
// class
/// ACRt@CNX
class CIconFile : public fnd::CMemBuffer
{
public:
	// RXgN^
	CIconFile(void);
	// fXgN^
	~CIconFile(void);

public:
	// Ǎ
	bool	Load (LPCTSTR lpFileName);
	bool	LoadA(LPCSTR  lpFileName);
	bool	LoadW(LPCWSTR lpFileName);
	// obt@Rs[
	bool	DuplicateOnMemory(const void* lpBuffer, u32 size);

	// 
	void	Release(void);

public:
	// ACRGg[̎擾
	LPICONDIRENTRY	GetEntry(int index);
	// ACRC[W̎擾
	bool			GetImage(int index, LPICONIMAGE pIconImage);
public:
	// t@CɊ܂܂ĂACR擾
	WORD			GetIconNum(void) const;

	// }XNf[^̃TCY̎擾
	static	u32		GetMaskSize(fnd::LPBMPINFOHEADER pbi);
public:
	// ICONDIR̎擾
	LPICONDIR		GetHeader(void)	const { return static_cast<LPICONDIR>(m_pBuffer); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
