//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHTTP.h
 * @brief		HTTPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXHTTP_H_
#define INCG_IRIS_WXHTTP_H_

//======================================================================
// include
#include "WXInetBase.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! HTTPNX
class CHTTP : public CInetBase
{
public:
	// RXgN^
	CHTTP(void);
	CHTTP(HINTERNET hConnect);
	// fXgN^
	~CHTTP(void);
public:

	// J
	HINTERNET	OpenRequest (LPCTSTR lpszVerb, LPCTSTR lpszObjectName, LPCTSTR lpszVersion, LPCTSTR lpszReferrer
						, LPCTSTR* lplpszAcceptTypes, DWORD dwFlags, DWORD_PTR dwContext);
	HINTERNET	OpenRequestA(LPCSTR  lpszVerb, LPCSTR  lpszObjectName, LPCSTR  lpszVersion, LPCSTR  lpszReferrer
						, LPCSTR*  lplpszAcceptTypes, DWORD dwFlags, DWORD_PTR dwContext);
	HINTERNET	OpenRequestW(LPCWSTR lpszVerb, LPCWSTR lpszObjectName, LPCWSTR lpszVersion, LPCWSTR lpszReferrer
						, LPCWSTR* lplpszAcceptTypes, DWORD dwFlags, DWORD_PTR dwContext);

	// 
	BOOL		AddRequestHeaders (LPCTSTR lpszHeaders, DWORD dwHeadersLength, DWORD dwModifiers);
	BOOL		AddRequestHeadersA(LPCSTR  lpszHeaders, DWORD dwHeadersLength, DWORD dwModifiers);
	BOOL		AddRequestHeadersW(LPCWSTR lpszHeaders, DWORD dwHeadersLength, DWORD dwModifiers);

	// 
	BOOL		SendRequest (LPCTSTR lpszHeaders, DWORD dwHeadersLength, LPVOID lpOptional, DWORD dwOptionalLength);
	BOOL		SendRequestA(LPCSTR  lpszHeaders, DWORD dwHeadersLength, LPVOID lpOptional, DWORD dwOptionalLength);
	BOOL		SendRequestW(LPCWSTR lpszHeaders, DWORD dwHeadersLength, LPVOID lpOptional, DWORD dwOptionalLength);

	//
	BOOL		SendRequestEx (LPINTERNET_BUFFERS  lpBuffersIn, LPINTERNET_BUFFERS  lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		SendRequestExA(LPINTERNET_BUFFERSA lpBuffersIn, LPINTERNET_BUFFERSA lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		SendRequestExW(LPINTERNET_BUFFERSW lpBuffersIn, LPINTERNET_BUFFERSW lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext=0);

	//
	BOOL		EndRequest (LPINTERNET_BUFFERS  lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		EndRequestA(LPINTERNET_BUFFERSA lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		EndRequestW(LPINTERNET_BUFFERSW lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext=0);

	//
	BOOL		QueryInfo (DWORD dwInfoLevel, LPVOID lpBuffer, LPDWORD lpdwBufferLength, LPDWORD lpdwIndex);
	BOOL		QueryInfoA(DWORD dwInfoLevel, LPVOID lpBuffer, LPDWORD lpdwBufferLength, LPDWORD lpdwIndex);
	BOOL		QueryInfoW(DWORD dwInfoLevel, LPVOID lpBuffer, LPDWORD lpdwBufferLength, LPDWORD lpdwIndex);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
