//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFileTime.h
 * @brief		t@C^CNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFileTime_H_
#define INCG_IRIS_WXFileTime_H_

//======================================================================
// include
#include "iris_object.h"
#include <time.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! t@C^CNX
class CFileTime
{
private:
	FILETIME	m_FileTime;	//!< t@C^C\
public:
	// RXgN^
	CFileTime(void);
	CFileTime(const FILETIME& ft);
	// fXgN^
	~CFileTime(void);

public:
	// operator
						operator FILETIME& (void)	{ return m_FileTime; }
	FILETIME&			operator ()(void)			{ return m_FileTime; }
	const FILETIME&		operator ()(void) const		{ return m_FileTime; }
	CFileTime&			operator = (const FILETIME& ft)	{ m_FileTime = ft; return *this; }

public:
	// localize
	BOOL	Loacalize(const FILETIME* ft);
	BOOL	Loacalize(void)		{ return Loacalize(&m_FileTime); }
	// nationalize
	BOOL	Nationalize(const FILETIME* ft);
	BOOL	Nationalize(void)	{ return Nationalize(&m_FileTime); }

public:
	// system timeɕϊ
	BOOL	ToSystemTime(LPSYSTEMTIME lpSysTime)	const;
	// system timeϊ
	BOOL	FromSystemTime(const LPSYSTEMTIME lpSysTime);
	// tm \̂ɕϊ
	BOOL	ToTM(tm* lptm)	const;
	// tm \̂ݒ
	BOOL	FromTM(const tm* lptm);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
