//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindFile.cpp
 * @brief		t@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFindFile_CPP_

//======================================================================
// include
#include "WXFindFile.h"

namespace iris {
namespace wx
{

//======================================================================
// class
// CFindFileA
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFindFileA::CFindFileA(void)
: m_hHandle(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFindFileA::~CFindFileA(void)
{
	Close();
}

/**********************************************************************//**
 *
 * 擪
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@CpX
 * @return	t@Cnh
*//***********************************************************************/
BOOL CFindFileA::FindFirst(LPCSTR lpFileName)
{
	m_hHandle = FindFirstFileA(lpFileName, this);
	if( m_hHandle == INVALID_HANDLE_VALUE ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	t@Cnh
*//***********************************************************************/
BOOL CFindFileA::FindNext(void)
{
	return FindNextFileA(m_hHandle, this);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CFindFileA::Close(void)
{
	return FindClose(m_hHandle);
}

// CFindFileW
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFindFileW::CFindFileW(void)
: m_hHandle(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFindFileW::~CFindFileW(void)
{
	Close();
}

/**********************************************************************//**
 *
 * 擪
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@CpX
 * @return	t@Cnh
*//***********************************************************************/
BOOL CFindFileW::FindFirst(LPCWSTR lpFileName)
{
	m_hHandle = FindFirstFileW(lpFileName, this);
	if( m_hHandle == INVALID_HANDLE_VALUE ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	t@Cnh
*//***********************************************************************/
BOOL CFindFileW::FindNext(void)
{
	return FindNextFileW(m_hHandle, this);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CFindFileW::Close(void)
{
	return FindClose(m_hHandle);
}

}	// end of namespace wx
}	// end of namespace iris

