//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindFile.h
 * @brief		t@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFindFile_H_
#define INCG_IRIS_WXFindFile_H_

//======================================================================
// include
#include <stdio.h>
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
class CFindFileA;
class CFindFileW;

//======================================================================
// typedef
#ifdef UNICODE
typedef CFindFileW	CFindFile;
#else
typedef CFindFileA	CFindFile;
#endif

//======================================================================
// class
//! t@CNX(MultiByte)
class CFindFileA : public IIrisObject, public WIN32_FIND_DATAA
{
public:
	HANDLE	m_hHandle;	//!< nh
public:
	// RXgN^
	CFindFileA(void);
	// fXgN^
	~CFindFileA(void);

public:
	// 擪
	BOOL	FindFirst(LPCSTR lpFileName);
	// 
	BOOL	FindNext(void);
	// 
	BOOL	Close(void);
};

//! t@CNX(Unicode)
class CFindFileW : public IIrisObject, public WIN32_FIND_DATAW
{
public:
	HANDLE	m_hHandle;	//!< nh
public:
	// RXgN^
	CFindFileW(void);
	// fXgN^
	~CFindFileW(void);

public:
	// 擪
	BOOL	FindFirst(LPCWSTR lpFileName);
	// 
	BOOL	FindNext(void);
	// 
	BOOL	Close(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
