//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHFile.cpp
 * @brief		t@CnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXHFile_CPP_

//======================================================================
// include
#include "WXHFile.h"
#include "../wx_inchead.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
// CHFile
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CHFile::CHFile(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hFile		= ֘Atnh
*//***********************************************************************/
CHFile::CHFile(HANDLE hFile)
: CHandle(hFile)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CHFile::~CHFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName				= t@C
 * @param [in]	dwDesiredAccess			= ANZX[h( GENERIC_*** or 0 )
 * @param [in]	dwShareMode				= L[h(FILE_SHARE_*** or 0)
 * @param [in]	lpSecurityAttributes	= ZLeBLqq
 * @param [in]	dwCreationDisposition	= 쐬@(CREATE_*** or OPEN_*** or TRUNCATE_EXISTING)
 * @param [in]	dwFlagsAndAttributes	= t@C(FILE_ATTRIBUTE_***)
 * @param [in]	hTemplateFile			= ev[gt@C̃nh
 * @return	
*//***********************************************************************/
BOOL CHFile::Open (LPCTSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes
					, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
#ifdef UNICODE
	return OpenW(lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes
		, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
#else
	return OpenA(lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes
		, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
#endif
}
/// CHFile::Open Q
BOOL CHFile::OpenA(LPCSTR  lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes
					, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
	HANDLE hObject = CreateFileA( lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes
		, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile );
	if( hObject == INVALID_HANDLE_VALUE ) return FALSE;
	return TryAttach(hObject);
}
/// CHFile::Open Q
BOOL CHFile::OpenW(LPCWSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes
					, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
	HANDLE hObject = CreateFileW( lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes
		, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile );
	if( hObject == INVALID_HANDLE_VALUE ) return FALSE;
	return TryAttach(hObject);
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@C
 * @param [in]	mode		= [h
 * @return	
*//***********************************************************************/
BOOL CHFile::Open (LPCTSTR lpFileName, LPCTSTR mode)
{
#ifdef UNICODE
	return OpenW(lpFileName, mode);
#else
	return OpenA(lpFileName, mode);
#endif
}
/// CHFile::Open Q
BOOL CHFile::OpenA(LPCSTR  lpFileName, LPCSTR  mode)
{
	DWORD access = 0;
	DWORD share = FILE_SHARE_READ|FILE_SHARE_WRITE;
	DWORD create = OPEN_EXISTING;
	if( mode == nullptr ) return FALSE;
	do
	{
		switch( *mode )
		{
		case 'r':
			access |= GENERIC_READ;
			break;
		case 'w':
			access |= GENERIC_WRITE;
			break;
		}
		create |= CREATE_ALWAYS;
	} while(*(++mode) != '\0' );
	return OpenA(lpFileName, access, share, nullptr, create
		, FILE_ATTRIBUTE_NORMAL, nullptr);
}
/// CHFile::Open Q
BOOL CHFile::OpenW(LPCWSTR lpFileName, LPCWSTR mode)
{
	DWORD access = 0;
	DWORD share = FILE_SHARE_READ|FILE_SHARE_WRITE;
	DWORD create = OPEN_EXISTING;
	if( mode == nullptr ) return FALSE;
	do
	{
		switch( *mode )
		{
		case L'r':
			access |= GENERIC_READ;
			break;
		case L'w':
			access |= GENERIC_WRITE;
			break;
		}
		create |= CREATE_ALWAYS;
	} while(*(++mode) != L'\0' );
	return OpenW(lpFileName, access, share, nullptr, create
		, FILE_ATTRIBUTE_NORMAL, nullptr);
}

/**********************************************************************//**
 *
 * t@CTCY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpdwSizeHigh	= 
 * @return	t@CTCY
*//***********************************************************************/
DWORD CHFile::GetSize(LPDWORD lpdwSizeHigh)	const
{
	return GetFileSize(m_hObject, lpdwSizeHigh);
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer		= o̓obt@
 * @param [in]	dwSize			= o̓obt@TCY
 * @param [in]	lpdwRead		= ǂݍ񂾃TCY
 * @param [in]	lpOverlapped	= FILE_FLAG_OVERLAPPED ̂ƂK{
 * @return	
*//***********************************************************************/
BOOL CHFile::Read(void* lpBuffer, DWORD dwSize, LPDWORD lpdwRead, LPOVERLAPPED lpOverlapped)
{
	IRIS_ASSERT( lpdwRead != nullptr );
	return ReadFile(m_hObject, lpBuffer, dwSize, lpdwRead, lpOverlapped);
}

/**********************************************************************//**
 *
 * ǂݍ݁iIR[obN̐ݒ肪\j
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer		= o̓obt@
 * @param [in]	dwSize			= o̓obt@TCY
 * @param [in]	lpFunction		= [`
 * @param [in]	lpOverlapped	= FILE_FLAG_OVERLAPPED ̂ƂK{
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CHFile::ReadEx(void* lpBuffer, DWORD dwSize, LPOVERLAPPED_COMPLETION_ROUTINE lpFunction, LPOVERLAPPED lpOverlapped)
{
	return ReadFileEx(m_hObject, lpBuffer, dwSize, lpOverlapped, lpFunction);
}
#endif

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer		= o̓obt@
 * @param [in]	dwSize			= o̓obt@TCY
 * @param [in]	lpdwWritten		= 񂾃TCY
 * @param [in]	lpOverlapped	= FILE_FLAG_OVERLAPPED ̂ƂK{
 * @return	
*//***********************************************************************/
BOOL CHFile::Write(void* lpBuffer, DWORD dwSize, LPDWORD lpdwWritten, LPOVERLAPPED lpOverlapped)
{
	return WriteFile(m_hObject, lpBuffer, dwSize, lpdwWritten, lpOverlapped);
}

/**********************************************************************//**
 *
 * ݁iIR[obN̐ݒ肪\j
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer		= o̓obt@
 * @param [in]	dwSize			= o̓obt@TCY
 * @param [in]	lpFunction		= [`
 * @param [in]	lpOverlapped	= FILE_FLAG_OVERLAPPED ̂ƂK{
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CHFile::WriteEx(void* lpBuffer, DWORD dwSize, LPOVERLAPPED_COMPLETION_ROUTINE lpFunction, LPOVERLAPPED lpOverlapped)
{
	return WriteFileEx(m_hObject, lpBuffer, dwSize, lpOverlapped, lpFunction);
}
#endif

/**********************************************************************//**
 *
 * Flush
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CHFile::Flush(void)
{
	return FlushFileBuffers(m_hObject);
}

/**********************************************************************//**
 *
 * t@C̈ʒu擾
 *
 ----------------------------------------------------------------------
 * @return	t@C̈ʒu
*//***********************************************************************/
DWORD CHFile::Tell(void)	const
{
	return ::SetFilePointer(m_hObject, 0, nullptr, FILE_CURRENT);
}

/**********************************************************************//**
 *
 * t@C̈ʒuړ
 *
 ----------------------------------------------------------------------
 * @param [in]	lOffset			= ړ
 * @param [in]	lpOffsetHigh	= ړʂ̏LONGl(nullptr)
 * @param [in]	MoveMethod		= FILE_***
 * @return	Vʒu
*//***********************************************************************/
DWORD CHFile::Seek(LONG lOffset, PLONG lpOffsetHigh, DWORD MoveMethod)
{
	return ::SetFilePointer(m_hObject, lOffset, lpOffsetHigh, MoveMethod);
}

/**********************************************************************//**
 *
 * t@C̏I[Ɉړ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CHFile::SetEndOfFile(void)
{
	return ::SetEndOfFile(m_hObject);
}

/**********************************************************************//**
 *
 * t@C̈̃bN
 *
 ----------------------------------------------------------------------
 * @param [in]	dwOffsetLow		= t@CItZbgiʁj
 * @param [in]	dwOffsetHigh	= t@CItZbgiʁj(Windows95/98 must 0)
 * @param [in]	dwSizeLow		= bNTCYiʁj
 * @param [in]	dwSizeHigh		= bNTCYiʁj
 * @return	
*//***********************************************************************/
BOOL CHFile::Lock(DWORD dwOffsetLow, DWORD dwOffsetHigh, DWORD dwSizeLow, DWORD dwSizeHigh)
{
	return LockFile(m_hObject, dwOffsetLow, dwOffsetHigh, dwSizeLow, dwSizeHigh);
}

/**********************************************************************//**
 *
 * t@C̈̃bN
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags			= 
 * @param [in]	dwSizeLow		= bNTCYiʁj
 * @param [in]	dwSizeHigh		= bNTCYiʁj
 * @param [in]	lpOverlapped	= 
 * @return	
*//***********************************************************************/
BOOL CHFile::LockEx(DWORD dwFlags, DWORD dwSizeLow, DWORD dwSizeHigh, LPOVERLAPPED lpOverlapped)
{
	return LockFileEx(m_hObject, dwFlags, 0, dwSizeLow, dwSizeHigh, lpOverlapped);
}

/**********************************************************************//**
 *
 * t@C̈̃bN
 *
 ----------------------------------------------------------------------
 * @param [in]	dwOffsetLow		= t@CItZbgiʁj
 * @param [in]	dwOffsetHigh	= t@CItZbgiʁj(Windows95/98 must 0)
 * @param [in]	dwSizeLow		= bNTCYiʁj
 * @param [in]	dwSizeHigh		= bNTCYiʁj
 * @return	
*//***********************************************************************/
BOOL CHFile::Unlock(DWORD dwOffsetLow, DWORD dwOffsetHigh, DWORD dwSizeLow, DWORD dwSizeHigh)
{
	return UnlockFile(m_hObject, dwOffsetLow, dwOffsetHigh, dwSizeLow, dwSizeHigh);
}

/**********************************************************************//**
 *
 * t@C̈̃bN
 *
 ----------------------------------------------------------------------
 * @param [in]	dwSizeLow		= bNTCYiʁj
 * @param [in]	dwSizeHigh		= bNTCYiʁj
 * @param [in]	lpOverlapped	= 
 * @return	
*//***********************************************************************/
BOOL CHFile::UnlockEx(DWORD dwSizeLow, DWORD dwSizeHigh, LPOVERLAPPED lpOverlapped)
{
	return UnlockFileEx(m_hObject, 0, dwSizeLow, dwSizeHigh, lpOverlapped);
}

/**********************************************************************//**
 *
 * OVERLAPPED ̌ʎ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpOverlapped	= OVERLAPPED
 * @param [in]	lpNumberOfBytes	= ]ꂽoCg
 * @param [in]	bWait			= tO
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CHFile::GetOverlappedResult(LPOVERLAPPED lpOverlapped, LPDWORD lpNumberOfBytes, BOOL bWait)
{
	return ::GetOverlappedResult(m_hObject, lpOverlapped, lpNumberOfBytes, bWait);
}
#endif

/**********************************************************************//**
 *
 * t@C̎Ԋ֌W̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpCreation		= 쐬
 * @param [in]	lpLastAccess	= ANZX
 * @param [in]	lpLastWrite		= XV
 * @return	
*//***********************************************************************/
BOOL CHFile::GetFileTime(LPFILETIME lpCreation, LPFILETIME lpLastAccess, LPFILETIME lpLastWrite)
{
	return ::GetFileTime(m_hObject, lpCreation, lpLastAccess, lpLastWrite);
}

/**********************************************************************//**
 *
 * t@C̎Ԋ֌W̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpCreation		= 쐬
 * @param [in]	lpLastAccess	= ANZX
 * @param [in]	lpLastWrite		= XV
 * @return	
*//***********************************************************************/
BOOL CHFile::SetFileTime(const FILETIME* lpCreation, const FILETIME* lpLastAccess, const FILETIME* lpLastWrite)
{
	return ::SetFileTime(m_hObject, lpCreation, lpLastAccess, lpLastWrite);
}

}	// end of namespace wx
}	// end of namespace iris

