//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGlobalMemory.h
 * @brief		O[onhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXGlobalMemory_H_
#define INCG_IRIS_WXGlobalMemory_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx 
{

//======================================================================
// decalre
class CGlobalMemory;

//======================================================================
// typedef
typedef CGlobalMemory	CGMem;	//!< O[onhNX

//======================================================================
// class
//! O[onhNX
class CGlobalMemory : public INonCopyable<CGlobalMemory>
{
	HGLOBAL m_hMem;	//!< nh
public:
	// RXgN^
	CGlobalMemory(void);
	// fXgN^
	virtual ~CGlobalMemory(void);

	//
	HGLOBAL			GetHandle(void)				{ return m_hMem; }
	operator		HGLOBAL	(void)				{ return GetHandle(); }
	CGlobalMemory&	operator = (HGLOBAL hMem)	{ Attach(hMem); return *this; }

public:
	// Attach
	HGLOBAL	Attach(HGLOBAL hMem);
	// Detach
	HGLOBAL	Detach(void);
public:
	// Alloc
	bool	Alloc(UINT uFlags, SIZE_T dwBytes);
	// ReAlloc
	bool	ReAlloc(UINT uFlags, SIZE_T dwBytes);
	// 폜
	void	Discard(void);
	// 
	void	Free(void);
	// Lock
	LPVOID	Lock(void);
	// Unlock
	BOOL	Unlock(void);

public:
	// TCY擾
	SIZE_T	GetSize(void)	const;
	// tO擾
	UINT	GetFlags(void)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
