//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVirtualMemory.cpp
 * @brief		znhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXVirtualMemory_CPP_

//======================================================================
// include
#include "WXVirtualMemory.h"

namespace iris {
namespace wx 
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CVirtualMemory::CVirtualMemory(void)
: m_pReserve(nullptr)
, m_Size(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CVirtualMemory::~CVirtualMemory(void)
{
	Free();
}

/**********************************************************************//**
 *
 * y[W\
 *
 ----------------------------------------------------------------------
 * @param [in]	lpAddr		= 蓖Ă鉼zAhX(nullptr=VXeC)
 * @param [in]	dwSize		= 蓖ĂTCY
 * @param [in]	dwProtect	= PAGE_***
 * @param [in]	dwTypeOpt	= 蓖ă^CvMEM_***(AND)
 * @return	
*//***********************************************************************/
bool CVirtualMemory::Reserve(LPVOID lpAddr, SIZE_T dwSize, DWORD dwProtect, DWORD dwTypeOpt)
{
	m_pReserve = Alloc(lpAddr, dwSize, MEM_RESERVE|dwTypeOpt, dwProtect);
	m_Size = dwSize;
	return (m_pReserve != nullptr);
}

/**********************************************************************//**
 *
 * R~bg
 *
 ----------------------------------------------------------------------
 * @param [in]	lpAddr		= 蓖Ă鉼zAhX(nullptr=VXeC)
 * @param [in]	dwSize		= 蓖ĂTCY
 * @param [in]	dwProtect	= PAGE_***
 * @param [in]	dwTypeOpt	= 蓖ă^CvMEM_***(AND)
 * @return	
*//***********************************************************************/
LPVOID CVirtualMemory::Commit(SIZE_T dwSize, DWORD dwProtect, DWORD dwTypeOpt)
{
	return Alloc(m_pReserve, dwSize, MEM_COMMIT|dwTypeOpt, dwProtect);
}

/**********************************************************************//**
 *
 * R~bg̈̉
 *
*//***********************************************************************/
BOOL CVirtualMemory::Decommit(LPVOID lpAddr, SIZE_T dwSize)
{
	if( m_pReserve == nullptr ) return FALSE;
	return VirtualFree(lpAddr, dwSize, MEM_DECOMMIT);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CVirtualMemory::Free(void)
{
	if( m_pReserve == nullptr ) return;
	VirtualFree(m_pReserve, 0, MEM_RELEASE);
	m_pReserve = nullptr;
	m_Size = 0;
}

/**********************************************************************//**
 *
 * Lock
 *
 ----------------------------------------------------------------------
 * @param [in]	dwSize	= bNAhX
 * @param [in]	dwSize	= bNTCY
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CVirtualMemory::Lock(LPVOID lpAddr, SIZE_T dwSize)
{
	if( m_pReserve == nullptr ) return FALSE;
	return VirtualLock(lpAddr, dwSize);
}
#endif

/**********************************************************************//**
 *
 * Unlock
 *
 ----------------------------------------------------------------------
 * @param [in]	dwSize	= bNAhX
 * @param [in]	dwSize	= bNTCY
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CVirtualMemory::Unlock(LPVOID lpAddr, SIZE_T dwSize)
{
	return VirtualUnlock(lpAddr, dwSize);
}
#endif

/**********************************************************************//**
 *
 * Protect
 *
 ----------------------------------------------------------------------
 * @param [in]	lpAddr		= 蓖Ă鉼zAhX(nullptr=VXeC)
 * @param [in]	dwSize		= 蓖ĂTCY
 * @param [in]	dwProtect	= PAGE_***
 * @param [in]	lpdwOld		= ȑÕANZXی
 * @return	
*//***********************************************************************/
BOOL CVirtualMemory::Protect(LPVOID lpAddr, SIZE_T dwSize, DWORD dwProtect, LPDWORD lpdwOld)
{
	return VirtualProtect(lpAddr, dwSize, dwProtect, lpdwOld);
}

/**********************************************************************//**
 *
 * Alloc
 *
 ----------------------------------------------------------------------
 * @param [in]	lpAddr		= 蓖Ă鉼zAhX(nullptr=VXeC)
 * @param [in]	dwSize		= 蓖ĂTCY
 * @param [in]	dwType		= 蓖ă^CvMEM_***
 * @param [in]	dwProtect	= PAGE_***
 * @return	
*//***********************************************************************/
LPVOID CVirtualMemory::Alloc(LPVOID lpAddr, SIZE_T dwSize, DWORD dwType, DWORD dwProtect)
{
	return VirtualAlloc(lpAddr, dwSize, dwType, dwProtect);
}

}	// end of namespace wx
}	// end of namespace iris
