//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMTimer.cpp
 * @brief		^C}[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMTimer_CPP_

//======================================================================
// include
#include "WXMMTimer.h"
#include "fnd/system/FndFps.h"
#include <mmsystem.h>

//======================================================================
// link
#pragma comment( lib, "winmm.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMTimer::CMMTimer(void)
: m_fTosec(1.0f/1000.0f)
{
	timeBeginPeriod(1);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMTimer::~CMMTimer(void)
{
	timeEndPeriod(1);
}

/**********************************************************************//**
 *
 * ݂̎擾
 *
 -----------------------------------------------------------------------
 * @return ݂̎
*//***********************************************************************/
u64 CMMTimer::GetNowTime(void)	const
{
	return (u64)timeGetTime();
}

/**********************************************************************//**
 *
 * oߎԂ̎擾
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
u64 CMMTimer::GetElapsedMilliSecond(void)	const
{
	u64 time = GetNowTime();
	u64 elapsedtime = (time - m_LastTime);
	m_LastTime = time;
	return elapsedtime;
}

/**********************************************************************//**
 *
 * AvP[VԂ̎擾
 *
 -----------------------------------------------------------------------
 * @return NĂ̎
*//***********************************************************************/
u64 CMMTimer::GetStockMilliSecond(void)	const
{
	u64 time = GetNowTime();
	return (time - m_BaseTime);
}

/**********************************************************************//**
 *
 * oߎԂ̎擾iXVj
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
u64 CMMTimer::GetElapsedMilliSecondRef(void)	const
{
	u64 time = GetNowTime();
	u64 elapsedtime = (time - m_LastTime);
	return elapsedtime;
}

/**********************************************************************//**
 *
 * Sync
 *
 ----------------------------------------------------------------------
 * @return	syncꍇ́Atrue
*//***********************************************************************/
bool CMMTimer::Sync(bool sleep)
{
	while(1)
	{
		u64 mspf = (u64)fnd::MSPF();
		u64 time = GetElapsedMilliSecondRef();
		if( time > mspf )
		{
			m_LastTime += mspf;
			return true;
		}
		if( !sleep ) break;

		Sleep((DWORD)(mspf-time));
	}
	return false;
}

/**********************************************************************//**
 *
 * oߎԂ̎擾iSyncj
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
float CMMTimer::GetSyncElapsedSecond(void)	const
{
	return fnd::SPF();
}

}	// end of namespace wx
}	// end of namespace iris
