//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPop3.cpp
 * @brief		Pop3vgRNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPop3_CPP_

//======================================================================
// include
#include "WXPop3.h"

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPop3Client::CPop3Client(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPop3Client::~CPop3Client(void)
{
}

/**********************************************************************//**
 *
 * OC
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszHost		= 
 * @param [in]	lpszName		= 
 * @param [in]	lpszPassword	=
 * @return	
*//***********************************************************************/
BOOL CPop3Client::Login(LPCSTR lpszHost, LPCSTR lpszName, LPCSTR lpszPassword)
{
	// \PbgI[v
	if( !Open(AF_INET, SOCK_STREAM, 0) ) return FALSE;

	// zXgAhXɕϊ
	LPHOSTENT hostent=gethostbyname(lpszHost);
	if(!hostent ||
		hostent->h_addrtype != AF_INET ||
		hostent->h_length	!= 4 ||
		!hostent->h_addr_list[0]) return FALSE;

	// AhX|[g̓o^
	u_short	port = 110;
	sockaddr_in sa;
	ZeroMemory(&sa, sizeof(sa));
	sa.sin_family		= AF_INET;
	sa.sin_addr.s_addr	= *(unsigned long*)(hostent->h_addr_list[0]);
	sa.sin_port			= htons(port);

	// POP3T[oɐڑ
	if( Connect((sockaddr*)&sa, sizeof(sa)) || !IsStatusOK()) return FALSE;
	
	// [U𑗂
	std::string name = "USER ";
	name += lpszName;
	if( !SendNL(name.c_str(), (int)name.length(), 0) || !IsStatusOK()) return FALSE;
	
	// pX[h𑗂
	std::string pass = "PASS ";
	pass += lpszPassword;
	if( !SendNL(pass.c_str(), (int)pass.length(), 0) || !IsStatusOK()) return FALSE;

	return TRUE;
}

/**********************************************************************//**
 *
 * OAEg
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CPop3Client::Logout(void)
{
	CHAR message[32] = "QUIT";
	if(!SendNL(message, (int)strlen(message), 0) || !IsStatusOK()) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * STAT
 *
 ----------------------------------------------------------------------
 * @param [in]	lpMailCnt	= [
 * @param [in]	lpdwSize	= [TCY
 * @return	
*//***********************************************************************/
BOOL CPop3Client::Stat(LPINT lpMailCnt, LPDWORD lpdwSize)
{
	CHAR cmd[] = "STAT";
	if( SendNL(cmd, (int)strlen(cmd), 0 ) == 0 ) return FALSE;
	CHAR recv[2048];
	if( Recv(recv, sizeof(recv), 0 ) == 0 ) return FALSE;
	if( strstr(recv, "+OK") != recv ) return FALSE;
	LPSTR p1 = strchr(recv, ' ' );
	if( p1 == nullptr ) return FALSE;
	LPSTR p2 = strchr(p1+1, ' ' );
	if( p2 == nullptr ) return FALSE;
	if( lpdwSize != nullptr )
	{
		(*lpdwSize) = atoi(p2+1);
		p2 = '\0';
	}
	if( lpMailCnt )
	{
		(*lpMailCnt) = atoi(p1+1);
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * LIST
 *
 ----------------------------------------------------------------------
 * @param [in]	recv		= MbZ[W
 * @param [in]	nIndex		= [CfbNX(-1 = S)
 * @return	
*//***********************************************************************/
BOOL CPop3Client::List(std::string& rRecv, int nIndex)
{
	CHAR cmd[32] = "LIST";
	if( nIndex >= 0 )
	{
		wsprintfA( cmd, "LIST %d", nIndex); 
	}
	if( SendNL(cmd, (int)strlen(cmd), 0 ) == 0 ) return FALSE;
	return RecvEnd(rRecv);
}

/**********************************************************************//**
 *
 * RETR
 *
 ----------------------------------------------------------------------
 * @param [in]	recv		= MbZ[W
 * @param [in]	nIndex		= [CfbNX
 * @return	
*//***********************************************************************/
BOOL CPop3Client::Retr(std::string& rRecv, int nIndex)
{
	CHAR cmd[32];
	wsprintfA( cmd, "RETR %d", nIndex); 
	if( SendNL(cmd, (int)strlen(cmd), 0 ) == 0 ) return FALSE;
	return RecvEnd(rRecv);
}

/**********************************************************************//**
 *
 * DELEi폜R}hj
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex		= [CfbNX
 * @return	
*//***********************************************************************/
BOOL CPop3Client::Dele(int nIndex)
{
	CHAR cmd[32];
	wsprintfA( cmd, "DELE %d", nIndex); 
	if( SendNL(cmd, (int)strlen(cmd), 0 ) == 0 ) return FALSE;
	return IsStatusOK();
}

/**********************************************************************//**
 *
 * RSETiF؊m㔭폜SĎj
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CPop3Client::Rset(void)
{
	CHAR cmd[] = "RSET";
	if( SendNL(cmd, (int)strlen(cmd), 0 ) == 0 ) return FALSE;
	return IsStatusOK();
}

/**********************************************************************//**
 *
 * NOOPiȂR}hj
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CPop3Client::Noop(void)
{
	CHAR cmd[] = "NOOP";
	if( SendNL(cmd, (int)strlen(cmd), 0 ) == 0 ) return FALSE;
	return IsStatusOK();
}

/**********************************************************************//**
 *
 * TOP
 *
 ----------------------------------------------------------------------
 * @param [in]	recv		= MbZ[W
 * @param [in]	nIndex		= [CfbNX
 * @param [in]	nLine		= > 0 : {̍sA < 0 : wb_
 * @return	
*//***********************************************************************/
BOOL CPop3Client::Top(std::string& rRecv, int nIndex, int nLine)
{
	CHAR cmd[32];
	wsprintfA( cmd, "TOP %d %d", nIndex, nLine); 
	if( SendNL(cmd, (int)strlen(cmd), 0 ) == 0 ) return FALSE;
	return RecvEnd(rRecv);
}

/**********************************************************************//**
 *
 * Xe[^X̊mF
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CPop3Client::IsStatusOK(void)
{
	CHAR message[2048];
	if( !Recv(message, sizeof(message), 0) ) return FALSE;
	if( strstr(message, "+OK") != message ) 
	{
		puts("server returned the error.");
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * I[܂ŎM
 *
 ----------------------------------------------------------------------
 * @param [in]	recv		= MbZ[W
 * @return	
*//***********************************************************************/
BOOL CPop3Client::RecvEnd(std::string& rRecv)
{
	char recv[2048];
	if( Recv(recv, sizeof(recv), 0 ) == 0 ) return FALSE;
	if( strstr(recv, "+OK"__CRLF) != recv ) return FALSE;

	rRecv = "";
	while(1)
	{
		if( Recv(recv, sizeof(recv), 0 ) == 0 ) return FALSE;
		if( strcmp(recv, "."__CRLF) == 0 ) break;
		rRecv += recv;
	}
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "WXSocketCore.h"
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXPop3UnitTest,WXPop3UnitTest)
{
	CPop3Client pop3;
	CSocketCore core = CSocketCore::CreateImplement();
	core.Startup(MAKEWORD(1,1));

	puts("T[o[ɂ郁[擾܂B");
	char host[256];
	char name[256];
	char pass[256];
	std::cout << "zXg͂ĂB" << std::endl;
	std::cin >> host;
	std::cout << "O͂ĂB" << std::endl;
	std::cin >> name;
	std::cout << "pX͂ĂB" << std::endl;
	std::cin >> pass;
	if( !pop3.Login( host, name, pass ) ) 
	{
		std::cout << "OCɎs܂B" << std::endl;
		return;
	}

	int num;
	if( pop3.Stat(&num, nullptr) )
	{
		printf( "mail num = %d.\n", num );
	}
	else
	{
		puts("[͂܂B");
	}
	pop3.Logout();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
