//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSMTP.cpp
 * @brief		Simple Mail Transfer ProtocolNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSMTP_CPP_

//======================================================================
// include
#include "WXSMTP.h"
#include <tchar.h>

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSMTPClient::CSMTPClient(void)
: m_LastError(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSMTPClient::~CSMTPClient(void)
{
	//Logout();
}

/**********************************************************************//**
 *
 * OC
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszHost		= 
 * @return	
*//***********************************************************************/
BOOL CSMTPClient::Login(LPCSTR lpszHost)
{
	LPHOSTENT lpHost;	// zXg
	LPSERVENT lpServ;	// T[o[
	int iPort;			// |[g
	SOCKADDR_IN sockadd;

	// zXg擾
	lpHost = gethostbyname(lpszHost);
	if(lpHost == nullptr) { puts("failed gethostbyname.\n"); return FALSE; }

	// \PbgI[v
	if( !Open(PF_INET, SOCK_STREAM, 0) ) return FALSE;

	// T[o[擾
	lpServ = getservbyname("mail", nullptr);
	// |[gݒ
	if(lpServ == nullptr)
		iPort = htons(IPPORT_SMTP);
	else
		iPort = lpServ->s_port;

	// ڑ
	sockadd.sin_family	= AF_INET;
	sockadd.sin_port	= (u_short)iPort;
	sockadd.sin_addr	= *((LPIN_ADDR)*lpHost->h_addr_list);
	if(Connect((PSOCKADDR)&sockadd, sizeof(sockadd)))
	{
		puts("connect failed.\n");
		return FALSE;
	}
	return IsStatusOK();
}

/**********************************************************************//**
 *
 * OAEg
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CSMTPClient::Logout(void)
{
	char message[] = "QUIT";
	if(!SendNL(message, (int)strlen(message), 0) || !IsStatusOK()) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * HELLO
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszHost		= 
 * @return	
*//***********************************************************************/
BOOL CSMTPClient::Hello(LPCSTR lpszHost)
{
	if( lpszHost == nullptr ) return FALSE;
	std::string msg = "HELO ";
	msg += lpszHost;
	if( !SendNL(msg.c_str(), (int)msg.length(), 0 ) || !IsStatusOK() ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * MAIL FROM
 *
 ----------------------------------------------------------------------
 * @param [in]	lpAddress		= M҃AhX
 * @return	
*//***********************************************************************/
BOOL CSMTPClient::MailFrom(LPCSTR lpAddress)
{
	if( lpAddress == nullptr ) return FALSE;
	std::string msg = "MAIL FROM : <";
	msg += lpAddress;
	msg += ">";
	if( !SendNL(msg.c_str(), (int)msg.length(), 0 ) || !IsStatusOK() ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * RCPT TO
 *
 ----------------------------------------------------------------------
 * @param [in]	lpAddress		= M҃AhX
 * @return	
*//***********************************************************************/
BOOL CSMTPClient::RcptTo(LPCSTR lpAddress)
{
	if( lpAddress == nullptr ) return FALSE;
	std::string msg = "RCPT TO : <";
	msg += lpAddress;
	msg += ">";
	if( !SendNL(msg.c_str(), (int)msg.length(), 0 ) || !IsStatusOK() ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * DATA
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CSMTPClient::Data(void)
{
	std::string msg = "DATA";
	if( !SendNL(msg.c_str(), (int)msg.length(), 0 ) || !IsStatusOK() ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * DATA end
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CSMTPClient::End(void)
{
	std::string msg = __CRLF".";
	if( !SendNL(msg.c_str(), (int)msg.length(), 0 ) || !IsStatusOK() ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * Xe[^X̊mF
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CSMTPClient::IsStatusOK(void)
{
	CHAR recv[1024] = "";
	// T[o[̕ԐM擾
	if( Recv(recv, sizeof(recv), 0) == 0 ) return FALSE;
	char *p = strchr(recv,' ');
	m_LastError = 0;
	if(p != nullptr) 
	{
		p = '\0';
		m_LastError = (DWORD)atoi(recv);
		printf("SMTP error : %d.\n", m_LastError);
		return IsError();
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * G[ǂ
 *
 ----------------------------------------------------------------------
 * @retval	false	= G[
 * @retval	true	= 
*//***********************************************************************/
BOOL CSMTPClient::IsError(void)
{
	switch(m_LastError)
	{
	case 211:
	case 214:		// wvbZ[W
	case 220:		// 
	case 221:		// ڑ
	case 250:
	case 354:		// [̓͊Jn
		return TRUE;
	}
	return FALSE;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "WXSocketCore.h"
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXSMTPUnitTest, WXSMTPUnitTest)
{
	CSocketCore core = CSocketCore::CreateImplement();
	core.Startup(MAKEWORD(1,1));
	CSMTPClient smtp;
	char host[256];
	char from[1024];
	char to[1024];
	std::cout << "[𑗐M܂B" << std::endl;

	std::cout << "zXg͂ĂB" << std::endl;
	std::cin >> host;
	std::cout << "M[AhX͂ĂB" << std::endl;
	std::cin >> from;
	std::cout << "M惁[AhX͂ĂB" << std::endl;
	std::cin >> to;
	if( !smtp.Login(host) )
	{
		std::cout << "OCɎs܂B" << std::endl;
		return;
	}

	if( !smtp.Hello(host) ) goto exit;
	if( !smtp.MailFrom(from) ) goto exit;
	if( !smtp.RcptTo(to) ) goto exit;
	if( !smtp.Data() ) goto exit;

	smtp.SendNL("{");

	smtp.End();

exit:
	smtp.Logout();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
