//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSocketCore.cpp
 * @brief		winsocketRANXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSocketCore_CPP_

//======================================================================
// include
#include "WXSocketCore.h"
#include "fnd/utility/FndRefCounter.h"

//======================================================================
// link
#pragma comment ( lib, "wsock32.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class

namespace 
{

//! CWSA::NXCX^X
class CImplInstance : public fnd::CRefCounter
{
	WSADATA	m_data;
	bool	m_init;
public:
	static CImplInstance* s_pInstance;
public:
	CImplInstance::CImplInstance(void)
		: m_init(false)
	{
	}

	CImplInstance::~CImplInstance(void)
	{
		Cleanup();
	}

public:
	// 
	int	Startup(WORD version)
	{
		if( m_init ) return ERROR_SUCCESS;
		int ret = WSAStartup(version, &m_data);
		if( ret == ERROR_SUCCESS ) m_init = true;
		return ret;
	}

	// I
	int Cleanup(void)
	{
		if( GetRef() > 0 ) return ERROR_SUCCESS;
		if( !m_init ) return ERROR_SUCCESS;
		return WSACleanup();
	}

public:
	WSADATA*	GetData(void)	{ return &m_data; }
};

}	// end of namespace

//! CWSA::NX
class CSocketCore::CImpl : public CImplInstance
{
};

//======================================================================
// variable
CImplInstance* CImplInstance::s_pInstance = nullptr;

//======================================================================
// CSocket

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSocketCore::CSocketCore(void)
: m_pImpl(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSocketCore::CSocketCore(const CSocketCore& rObject)
: m_pImpl(rObject.m_pImpl)
{
	if( m_pImpl != nullptr ) m_pImpl->AddRef();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
CSocketCore& CSocketCore::operator = ( CSocketCore& rObject )
{
	m_pImpl = rObject.m_pImpl;
	if( m_pImpl != nullptr ) m_pImpl->AddRef();
	return *this;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSocketCore::~CSocketCore(void)
{
	if( m_pImpl == nullptr ) return;
	m_pImpl->SubRef();
	if( m_pImpl->GetRef() <= 0 )
	{
		IRIS_SAFE_DELETE( CImplInstance::s_pInstance );
		m_pImpl = nullptr;
	}
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	CToolHelpCX^X
*//***********************************************************************/
CSocketCore CSocketCore::CreateImplement(void)
{
	CSocketCore ref;
	CImpl* pImpl = static_cast<CImpl*>(CImplInstance::s_pInstance);
	if( pImpl == nullptr )
	{
		pImpl = new CImpl;
		CImplInstance::s_pInstance = pImpl;
	}
	pImpl->AddRef();
	ref.m_pImpl = pImpl;
	return ref;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	version	= o[W
 * @return	G[
 * @retval	0		= 
 * @retval	0ȊO	= G[萔
*//***********************************************************************/
int CSocketCore::Startup(WORD version)
{
	if( m_pImpl == nullptr ) return ERROR_INVALID_FUNCTION;
	return m_pImpl->Startup(version);
}

/**********************************************************************//**
 *
 * I
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
int CSocketCore::Cleanup(void)
{
	if( m_pImpl == nullptr ) return ERROR_INVALID_FUNCTION;
	return m_pImpl->Cleanup();
}

/**********************************************************************//**
 *
 * f[^擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
WSADATA* CSocketCore::GetData(void)
{
	if( m_pImpl == nullptr ) return nullptr;
	return m_pImpl->GetData();
}

/**********************************************************************//**
 *
 * G[l擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
int CSocketCore::GetLastError(void)
{
	return WSAGetLastError();
}

}	// end of namespace wx
}	// end of namespace iris
