//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMutex.cpp
 * @brief		mutexNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMutex_CPP_

//======================================================================
// include
#include "WXMutex.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMutex::CMutex(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
CMutex::CMutex(BOOL bInitiallyOwn, LPCTSTR lpszName, SECURITY_ATTRIBUTES* psaAttribute)
{
	Init(bInitiallyOwn, lpszName, psaAttribute);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMutex::~CMutex(void)
{
	Unlock();
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in] bInitiallyOwn	= 
 * @param [in] lpszName			= mutex
 * @param [in] psaAttribute		= ZLeBLqq
 * @return	
*//***********************************************************************/
BOOL CMutex::Init (BOOL bInitiallyOwn, LPCTSTR lpszName, SECURITY_ATTRIBUTES* psaAttribute)
{
#ifdef UNICODE
	return InitW(bInitiallyOwn, lpszName, psaAttribute);
#else
	return InitA(bInitiallyOwn, lpszName, psaAttribute);
#endif
}
/// iris::wx::CMutex::Init Q
BOOL CMutex::InitA(BOOL bInitiallyOwn, LPCSTR  lpszName, SECURITY_ATTRIBUTES* psaAttribute)
{
	HANDLE hMutex = ::CreateMutexA(psaAttribute, bInitiallyOwn, lpszName);
	if( hMutex == INVALID_HANDLE_VALUE ) return FALSE;
	if( !Attach(hMutex) )
	{
		CloseHandle(hMutex);
		return FALSE;
	}
	return TRUE;
}
/// iris::wx::CMutex::Init Q
BOOL CMutex::InitW(BOOL bInitiallyOwn, LPCWSTR lpszName, SECURITY_ATTRIBUTES* psaAttribute)
{
	HANDLE hMutex = ::CreateMutexW(psaAttribute, bInitiallyOwn, lpszName);
	if( hMutex == INVALID_HANDLE_VALUE ) return FALSE;
	if( !Attach(hMutex) )
	{
		CloseHandle(hMutex);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * ̖OtmutexJ
 *
 -----------------------------------------------------------------------
 * @param [in] dwDesiredAccess	= ANZX
 * @param [in] bInheritHandle	= pIvV
 * @param [in] lpName			= mutex
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CMutex::Open (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCTSTR lpName)
{
#ifdef UNICODE
	return OpenW(dwDesiredAccess, bInheritHandle, lpName);
#else
	return OpenA(dwDesiredAccess, bInheritHandle, lpName);
#endif
}
/// CMutex::Open Q
BOOL CMutex::OpenA(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR  lpName)
{
	HANDLE hMutex = ::OpenMutexA(dwDesiredAccess, bInheritHandle, lpName);
	if( hMutex == nullptr ) return FALSE;
	if( !Attach(hMutex) )
	{
		CloseHandle(hMutex);
		return FALSE;
	}
	return TRUE;
}
/// CMutex::Open Q
BOOL CMutex::OpenW(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName)
{
	HANDLE hMutex = ::OpenMutexW(dwDesiredAccess, bInheritHandle, lpName);
	if( hMutex == nullptr ) return FALSE;
	if( !Attach(hMutex) )
	{
		CloseHandle(hMutex);
		return FALSE;
	}
	return TRUE;
}
#endif

/**********************************************************************//**
 *
 * bN
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CMutex::Unlock(LONG lCount, LONG *pPrevCount)
{
	IRIS_UNUSED_VARIABLE(lCount);
	IRIS_UNUSED_VARIABLE(pPrevCount);
    return ::ReleaseMutex(m_hObject);
}


}	// end of namespace wx
}	// end of namespace iris
