//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXOSVersion.h
 * @brief		OS Version t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXOSVersion_H_
#define INCG_IRIS_WXOSVersion_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// function
// WindowsOSo[W̕o
BOOL	GetWindowsOSVersionString(LPTSTR lpString, DWORD dwLength);

//======================================================================
// class
/// o[WNX
class COSVersionInfo : public IIrisObject
{
public:
#if	!defined(IRIS_WIN32_WCE)
	typedef OSVERSIONINFOEX	OSVI;
#else
	typedef OSVERSIONINFO	OSVI;
#endif
	typedef OSVI			*LPOSVI;

private:
	OSVI	m_Osviex;	//!< o[W\
public:
	// RXgN^
	COSVersionInfo(void);
public:
	bool				GetString(LPTSTR lpString, DWORD dwLength);
	bool				IsValid(void)				{ return m_Osviex.dwOSVersionInfoSize != 0; }
	bool				IsEx(void)					{ return m_Osviex.dwOSVersionInfoSize == sizeof(OSVI); }

public:
	// Windows NT n
	bool				IsWindowsNT(void);
	// x86
	bool				IsX86(void);
	// x64
	bool				IsX64(void);

public:
	OSVI&	GetOSVersionInfo(void)		{ return m_Osviex; }
	operator OSVI&	(void)				{ return m_Osviex; }
	LPOSVI	operator -> (void)			{ return &m_Osviex; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
