//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProcess.h
 * @brief		vZXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXProcess_H_
#define INCG_IRIS_WXProcess_H_

//======================================================================
// include
#include "WXSyncObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// vZXNX
class CProcess : public ISyncObject
{
public:
	// RXgN^
	CProcess(void);
	CProcess(HANDLE hProcess);
	// fXgN^
	virtual ~CProcess(void);

public:
	// 쐬
	BOOL	Create (LPCTSTR lpApplicationName, LPTSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCTSTR lpCurrentDirectory
					   , LPSTARTUPINFO lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateA(LPCSTR  lpApplicationName, LPSTR  lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCSTR  lpCurrentDirectory
					   , LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateW(LPCWSTR lpApplicationName, LPWSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory
					   , LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lppi);

#if	!defined(IRIS_WIN32_WCE)
	BOOL	CreateAsUser (HANDLE hToken, LPCTSTR lpApplicationName, LPTSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCTSTR lpCurrentDirectory
					   , LPSTARTUPINFO lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateAsUserA(HANDLE hToken, LPCSTR  lpApplicationName, LPSTR  lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCSTR  lpCurrentDirectory
					   , LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateAsUserW(HANDLE hToken, LPCWSTR lpApplicationName, LPWSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory
					   , LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lppi);
#endif

	// N܂őҋ@
	void	WaitWakeup(void);
	// vZXI
	void	Destroy(DWORD dwTimeout=1000);
	// vZX̋I
	BOOL	Terminate(UINT uExitCode);
	// IĂ邩ǂ
	BOOL	IsExit(void);

public:

	// vZX̏IR[h̎擾
	DWORD	GetExitCode(void);
#if	!defined(IRIS_WIN32_WCE)
	// vZXID̎擾
	DWORD	GetProcessId(void);
	// vZX̎ԏ擾
	BOOL	GetProcessTimes(LPFILETIME lpCreationTime, LPFILETIME lpExitTime, LPFILETIME lpKernelTime, LPFILETIME lpUserTime);
	// vZX̃J[l[hł̌oߎԂ擾
	BOOL	GetProcessKernelTime(LPFILETIME lpKernelTime);
#endif

public:
	// vZXJ
	BOOL	Open(DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwProcessId);

private:
	// 쐬ʏ
	BOOL	_Create(LPPROCESS_INFORMATION lppid, LPPROCESS_INFORMATION lppis);
};

/// StartupNX
template<typename _SI>
class CTStartupInfo : public IIrisObject
{
	typedef _SI		value_type;
	typedef _SI		*value_ptr;
	typedef _SI		&value_ref;
public:
	value_type	m_si;
public:
	/// RXgN^
	CTStartupInfo(void)
	{
		ZeroMemory(&m_si, sizeof(m_si));
		m_si.cb = sizeof(m_si);
	}
public:
	// operator
	operator value_ptr (void)	{ return &m_si; }
	value_ref operator() (void)	{ return m_si; }
public:
	/// \ݒ
	void	Hide(void)
	{
		m_si.dwFlags |= STARTF_USESHOWWINDOW;
		m_si.wShowWindow = SW_HIDE;
	}
	/// 
	void	UseStdHandles(HANDLE hChildStdOut, HANDLE hChildStdIn, HANDLE hChildStdErr)
	{
		m_si.dwFlags |= STARTF_USESTDHANDLES;
		m_si.hStdOutput = hChildStdOut;
		m_si.hStdInput  = hChildStdIn;
		m_si.hStdError  = hChildStdErr;
	}
	/// 
	void	UseStdHandles(void)
	{
		m_si.dwFlags |= STARTF_USESTDHANDLES;
		m_si.hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
		m_si.hStdInput  = GetStdHandle(STD_INPUT_HANDLE);
		m_si.hStdError  = GetStdHandle(STD_ERROR_HANDLE);
	}
	/// XgA
	void	Restore(void)
	{
		if( m_si.dwFlags & STARTF_USESTDHANDLES )
		{
			if( GetStdHandle(STD_OUTPUT_HANDLE) == nullptr )
				freopen_s(nullptr, "CON", "w", stdout);
			if( GetStdHandle(STD_INPUT_HANDLE) == nullptr )
				freopen_s(nullptr , "CON", "r", stdin);
			if( GetStdHandle(STD_ERROR_HANDLE) == nullptr )
				freopen_s(nullptr, "CON", "w", stderr);
		}
	}
};
typedef CTStartupInfo<STARTUPINFO>	CStartupInfo;
typedef CTStartupInfo<STARTUPINFOA>	CStartupInfoA;
typedef CTStartupInfo<STARTUPINFOW>	CStartupInfoW;

/// vZXNX
class CProcessInfo : public INonCopyable<>
{
protected:
	PROCESS_INFORMATION	m_Info;	//!< vZX
public:
	// fXgN^
	virtual ~CProcessInfo(void);
public:
	/// vZX̎擾
			PROCESS_INFORMATION&	GetProcessInfo(void)		{ return m_Info; }
	const	PROCESS_INFORMATION&	GetProcessInfo(void) const	{ return m_Info; }
			PROCESS_INFORMATION*	operator () (void)			{ return &m_Info; }
	const	PROCESS_INFORMATION*	operator () (void)	const	{ return &m_Info; }
	operator 		PROCESS_INFORMATION*	(void)				{ return &m_Info; }
	operator const	PROCESS_INFORMATION*	(void)	const		{ return &m_Info; }

	PROCESS_INFORMATION* operator -> (void)	{ return &m_Info; }

public:
	// nh
	void	Close(void);

public:
	// vZXI
	void	Exit(void);
};


}	// end of namespace wx
}	// end of namespace iris

#endif
