//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXThread.h
 * @brief		Xbht@C
 *
 * @author		t.sirayanagi
 * @version		1.1
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXThread_H_
#define INCG_IRIS_WXThread_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	XbhnhNX
*/
class CThread : public CHandle
{
public:
	typedef	DWORD	return_type;
protected:
	DWORD	m_dwThreadId;	//!< Xbhԍ

public:
	// RXgN^
	CThread(void);
	// fXgN^
	virtual ~CThread(void);

public:
	// ̃nhJ
#if	!defined(IRIS_WIN32_WCE)
	bool	Open(DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwThreadId);
#endif
	// Xbh쐬
	bool	Create(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs=nullptr
		, DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr);
	bool	Create(PROC pStart, LPVOID lpArgs=nullptr
		, DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr);

	// Xbh쐬
#if	!defined(IRIS_WIN32_WCE)
	bool	CreateRemote(HANDLE hProcess, LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs=nullptr
		, DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr);
	bool	CreateRemote(HANDLE hProcess, PROC pStart, LPVOID lpArgs=nullptr
		, DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr);
#endif

	// 쐬Ăs
	bool	CreateStart(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs=nullptr
		, DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr);
	bool	CreateStart(PROC pStart, LPVOID lpArgs=nullptr
		, DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr);

	// Xbh̊Jn
	void	Start(void);
	// XbhI
	void	Stop(void);
	// JgXbh̒~
	virtual void	Exit(DWORD dwExitCode);
	// Xbh̏I҂
	DWORD	Wait(void);
	// sǂ擾
	bool	IsActive(void) const;

	// Xbhҋ@Ԃɂ
	void	Suspend(void);
	// ҋ@Ԃ̃XbhJn
	void	Resume(void);

	// XbhI
	BOOL	Terminate(void);

public:
	// Xbh̗D揇ʂύX
	BOOL	SetPriority(int Priority);
	// Xbh̗D揇ʂ擾
	int		GetPriority(void);
	// vCIeBu[Xg̏Ԃ擾
#if	!defined(IRIS_WIN32_WCE)
	BOOL	GetPriorityBoost(LPBOOL pDisablePriorityBoost);
#endif

	// XbhɃbZ[W𑗐M
	BOOL	PostMessageA(UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0);
	BOOL	PostMessageW(UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0);

protected:
	// Xbhnh̍쐬
	virtual HANDLE	_CreateThread(PROC pfnEntry, LPVOID lpArgs, DWORD dwStackSize, void* lpSecurity);
};

/**
 * XbhGg[NX
 */
template<class _THREAD, typename _RET=_THREAD::return_type>
class CThreadEntry : public _THREAD
{
	typedef _THREAD	_thread_type;
	typedef _RET	_return_type;
	typedef DWORD (WINAPI* START_ROUTINE)(void*);
private:
	// Xbh̎s
	static DWORD WINAPI Entry(void *pInstance)
	{
		if( pInstance != nullptr )
		{
			try
			{
				return reinterpret_cast<CThreadEntry*>(pInstance)->Run();
			}
			catch( ... )
			{
				return -1;
			}
		}
		return 0;
	}

public:
	// RXgN^
	CThreadEntry(void)	{}
	// fXgN^
	virtual ~CThreadEntry(void)	{}

protected:
	/// Xbh̎s
	virtual DWORD Run(void) { return 0; }

public:
	/// Xbh쐬
	bool	Create(START_ROUTINE pStart, LPVOID lpArgs=nullptr
		, DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr)
	{
		return _thread_type::Create(pStart, lpArgs, dwStackSize, lpThreadAttributes);
	}
	/// Xbh쐬
	bool	Create(DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr)
	{
		return this->Create(Entry, this, dwStackSize, lpThreadAttributes);
	}
	/// 쐬Ăs
	bool	CreateStart(DWORD dwStackSize=0, LPSECURITY_ATTRIBUTES lpThreadAttributes=nullptr)
	{
		if( !this->Create(Entry, this, dwStackSize, lpThreadAttributes) ) return false;
		Start();
		return true;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
