//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMappedProfile.h
 * @brief		ProfileNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMappedProfile_H_
#define INCG_IRIS_WXMappedProfile_H_

//======================================================================
// include
#include "WXPrivateProfile.h"
#include "stl/STLvecmap.h"
#include "stl/STLtstring.h"

namespace iris {
namespace wx 
{

//======================================================================
// class
//! MappedPrivateProfileNX
class CMappedPrivateProfile : public CPrivateProfile
{
public:
	// 
	typedef stl::tstring							std_tstring;
	typedef	std_tstring								KeyData;
	typedef std::pair<std_tstring, KeyData>			SectionPair;
	typedef stl::vecmap<std_tstring, KeyData>		SectionData;
	typedef std::pair<std_tstring, SectionData>		ProfilePair;
	typedef stl::vecmap<std_tstring, SectionData>	ProfileData;

private:
	// }bvf[^
	ProfileData	m_Profile;

public:
	// RXgN^
	CMappedPrivateProfile(void);
	// fXgN^
	virtual ~CMappedPrivateProfile(void);
public:
	// 
	virtual void	Close(void);

public:
	// ZNṼXg
	bool		MakeAppList(void);
	// L[̃Xg
	//	ŃZNṼXg܂
	bool		MakeKeyList(LPCTSTR lpAppName);
	// L[̃Xg
	static bool	MakeKeyList(LPCTSTR lpAppName, LPCTSTR lpFileName, SectionData& rData);

public:
	// ZNVEL[̃Xg
	bool		MakeProfileList(void);
	// Xg̃NA
	void		ClearProfileList(void);
	// Xg
	bool		WriteList(bool bClear);

public:
	// set, get
	// vt@C̎擾
	ProfileData&		GetProfileData(void)			{ return m_Profile; }
	const ProfileData&	GetProfileData(void)	const	{ return m_Profile; }

	// ZNV̎擾
	std_tstring*	GetAppName(int nIndex);
	// L[̎擾
	std_tstring*	GetKeyName(int nAppIndex, int nIndex);
	std_tstring*	GetKeyName(LPCTSTR lpAppName, int nIndex);
	// L[l̎擾
	KeyData*		GetKeyData(int nAppIndex, int nKeyIndex);
	KeyData*		GetKeyData(LPCTSTR lpAppName, int nKeyIndex);
	KeyData*		GetKeyData(LPCTSTR lpAppName, LPCTSTR lpKeyName);

	// ZNV폜
	BOOL			DeleteSection(LPCTSTR lpAppName);
	// L[폜
	BOOL			DeleteKey(LPCTSTR lpAppName, LPCTSTR lpKeyName);

public:

	// L[Xǧ
	SectionData*	FindSectionData(LPCTSTR lpAppName);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
