//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPrivateProfile.h
 * @brief		PrivateProfile NX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPrivateProfile_H_
#define INCG_IRIS_WXPrivateProfile_H_

//======================================================================
// include
#include "stl/STLvecmap.h"
#include "stl/STLtstring.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx 
{

//======================================================================
// function
// l̏
BOOL	WritePrivateProfileIntA(LPCSTR  lpAppName, LPCSTR  lpKeyName, UINT nValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileIntW(LPCWSTR lpAppName, LPCWSTR lpKeyName, UINT nValue, LPCWSTR lpFileName);
// l(HEX)̏
BOOL	WritePrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nValue, LPCWSTR lpFileName);
// l(HEX)̎擾
DWORD	GetPrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nDefault, LPCSTR  lpFileName);
DWORD	GetPrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nDefault, LPCWSTR lpFileName);
// l̏
BOOL	WritePrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fValue, LPCWSTR lpFileName);
// l̎擾
float	GetPrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fDefault, LPCSTR  lpFileName);
float	GetPrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fDefault, LPCWSTR lpFileName);
// WINDOWPLACEMENT̏
BOOL	WritePrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName);
BOOL	WritePrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName);
// WINDOWPLACEMENT̎擾
BOOL	GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCSTR  lpFileName);
BOOL	GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCWSTR lpFileName);
BOOL	GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName);
BOOL	GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName);

//======================================================================
// define
#ifdef UNICODE
#  define WritePrivateProfileInt				WritePrivateProfileIntW
#  define WritePrivateProfileHex				WritePrivateProfileHexW
#  define WritePrivateProfileFloat				WritePrivateProfileFloatW
#  define WritePrivateProfileWindowPlacement	WritePrivateProfileWindowPlacementW
#  define GetPrivateProfileHex					GetPrivateProfileHexW
#  define GetPrivateProfileFloat				GetPrivateProfileFloatW
#  define GetPrivateProfileWindowPlacement		GetPrivateProfileWindowPlacementW
#else
#  define WritePrivateProfileInt				WritePrivateProfileIntA
#  define WritePrivateProfileHex				WritePrivateProfileHexA
#  define WritePrivateProfileFloat				WritePrivateProfileFloatA
#  define WritePrivateProfileWindowPlacement	WritePrivateProfileWindowPlacementA
#  define GetPrivateProfileHex					GetPrivateProfileHexA
#  define GetPrivateProfileFloat				GetPrivateProfileFloatA
#  define GetPrivateProfileWindowPlacement		GetPrivateProfileWindowPlacementA
#endif

//======================================================================
// class
//! PrivateProfileNX
class CPrivateProfile : public IIrisObject
{
protected:
	// init@C
	TCHAR		m_Path[MAX_PATH];

public:
	// RXgN^
	CPrivateProfile(void);
	// fXgN^
	virtual ~CPrivateProfile(void);
public:
	// J
	virtual void	Open(LPCTSTR path);
	// 
	virtual void	Close(void);

public:

	// ZNV擾
	DWORD		GetSectionNames(LPTSTR lpReturn, DWORD nSize)	const;
	// ZNVɑ݂L[擾
	DWORD		GetSection	(LPCTSTR lpAppName, LPTSTR lpReturn, DWORD nSize)	const;
	// t@C當擾
	DWORD		GetString	(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPCTSTR lpDefault, LPTSTR lpReturn, DWORD nSize)	const;
	// t@C琮l擾
	UINT		GetInt		(LPCTSTR lpAppName, LPCTSTR lpKeyName, UINT nDefault)	const;
	// t@CHEXl擾
	DWORD		GetHex		(LPCTSTR lpAppName, LPCTSTR lpKeyName, DWORD dwDefault)	const;
	// t@C珬l擾
	float		GetFloat	(LPCTSTR lpAppName, LPCTSTR lpKeyName, float fDefault)	const;
	// t@C\̂擾
	DWORD		GetStruct	(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPVOID lpStruct, DWORD nSize)	const;
	// t@CWINDOWPLACEMENT擾
	DWORD		GetWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl)	const;
	DWORD		GetWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, HWND hWnd)	const;

	// t@CɃL[
	BOOL		WriteSection(LPCTSTR lpAppName, LPCTSTR lpString);
	// t@Cɐl
	BOOL		WriteInt	(LPCTSTR lpAppName, LPCTSTR lpKeyName, UINT nValue);
	// t@Cɏl
	BOOL		WriteFloat	(LPCTSTR lpAppName, LPCTSTR lpKeyName, float fValue);
	// t@CHEXl
	BOOL		WriteHex	(LPCTSTR lpAppName, LPCTSTR lpKeyName, DWORD dwValue);
	// t@Cɕ
	BOOL		WriteString	(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPCTSTR lpString);
	// t@Cɍ\̂
	BOOL		WriteStruct	(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPVOID lpStruct, DWORD nSize);
	// t@CWINDOWPLACEMENT
	BOOL		WriteWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, HWND hWnd);

	// t@CL[폜
	BOOL		RemoveKey(LPCTSTR lpAppName, LPCTSTR lpKeyName);
	// t@CZNV폜
	BOOL		RemoveSection(LPCTSTR lpAppName);
	// t@C폜
	BOOL		Remove(void);

public:
	// JĂ邩
	bool		IsOpen(void)	const	{ return (m_Path[0] != TEXT('\0')); }
	// 󂩂ǂ
	bool		IsEmpty(void)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
