//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXResource.cpp
 * @brief		\[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXResource_CPP_

//======================================================================
// include
#include <windowsx.h>
#include "WXResource.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CResource::CResource()
: m_hRsrc(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CResource::~CResource()
{
}

/**********************************************************************//**
 *
 * \[X̌
 *
 -----------------------------------------------------------------------
 * @param [in]	hModule	= W[nh
 * @param [in]	lpName	= \[XID
 * @param [in]	lpType	= RT_***
 * @return	
*//***********************************************************************/
BOOL CResource::Find (HMODULE hModule, LPCTSTR lpName, LPCTSTR lpType)
{
	m_hRsrc = ::FindResource(hModule, lpName, lpType);
	if( m_hRsrc == nullptr ) return FALSE;
	return TRUE;
}
/// CResource::Find Q
BOOL CResource::FindA(HMODULE hModule, LPCSTR  lpName, LPCSTR  lpType)
{
	m_hRsrc = ::FindResourceA(hModule, lpName, lpType);
	if( m_hRsrc == nullptr ) return FALSE;
	return TRUE;
}
/// CResource::Find Q
BOOL CResource::FindW(HMODULE hModule, LPCWSTR lpName, LPCWSTR lpType)
{
	m_hRsrc = ::FindResourceW(hModule, lpName, lpType);
	if( m_hRsrc == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * \[X̌
 *
 -----------------------------------------------------------------------
 * @param [in]	hModule	= W[nh
 * @param [in]	lpName	= \[XID
 * @param [in]	lpType	= RT_***
 * @param [in]	wLang	= w(MAKELANGID(,))
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CResource::FindEx (HMODULE hModule, LPCTSTR lpName, LPCTSTR lpType, WORD wLang)
{
	m_hRsrc = ::FindResourceEx (hModule, lpName, lpType, wLang);
	if( m_hRsrc == nullptr ) return FALSE;
	return TRUE;
}
/// CResource::FindEx Q
BOOL CResource::FindExA(HMODULE hModule, LPCSTR  lpName, LPCSTR  lpType, WORD wLang)
{
	m_hRsrc = ::FindResourceExA(hModule, lpName, lpType, wLang);
	if( m_hRsrc == nullptr ) return FALSE;
	return TRUE;
}
/// CResource::FindEx Q
BOOL CResource::FindExW(HMODULE hModule, LPCWSTR lpName, LPCWSTR lpType, WORD wLang)
{
	m_hRsrc = ::FindResourceExW(hModule, lpName, lpType, wLang);
	if( m_hRsrc == nullptr ) return FALSE;
	return TRUE;
}
#endif

/**********************************************************************//**
 *
 * \[X̃TCY擾
 *
 -----------------------------------------------------------------------
 * @return	\[XTCY
*//***********************************************************************/
DWORD CResource::GetSize(HMODULE hModule)
{
	return ::SizeofResource(hModule, m_hRsrc);
}

/**********************************************************************//**
 *
 * \[X̃[h
 *
 * @note	ȂĂ悢
 *
 -----------------------------------------------------------------------
 * @param [in]	hModule	= W[nh
 * @return	
*//***********************************************************************/
BOOL CResource::Load(HMODULE hModule)
{
	if( m_hRsrc == nullptr ) return FALSE;
	m_hMem = ::LoadResource(hModule, m_hRsrc);
	if( m_hMem == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * \[X̃bN
 *
 * @note	bN̉͂ȂĂ悢
 *
 -----------------------------------------------------------------------
 * @return	AhX
*//***********************************************************************/
LPVOID CResource::Lock(void)
{
	if( m_hMem == nullptr ) return nullptr;
	return ::LockResource(m_hMem);
}

}	// end of namespace wx
}	// end of namespace iris
