//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXResource.h
 * @brief		\[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXResource_H_
#define INCG_IRIS_WXResource_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! \[XNX
class CResource : public INonCopyable<>
{
protected:
	HRSRC	m_hRsrc;	//!< \[Xnh
	HGLOBAL	m_hMem;		//!< \[Xnh
public:
	// RXgN^
	CResource(void);
	// fXgN^
	~CResource(void);

public:
	// \[X̌
	BOOL	Find (HMODULE hModule, LPCTSTR lpName, LPCTSTR lpType);
	BOOL	FindA(HMODULE hModule, LPCSTR  lpName, LPCSTR  lpType);
	BOOL	FindW(HMODULE hModule, LPCWSTR lpName, LPCWSTR lpType);

	// \[X̌
#if	!defined(IRIS_WIN32_WCE)
	BOOL	FindEx (HMODULE hModule, LPCTSTR lpName, LPCTSTR lpType, WORD wLang);
	BOOL	FindExA(HMODULE hModule, LPCSTR  lpName, LPCSTR  lpType, WORD wLang);
	BOOL	FindExW(HMODULE hModule, LPCWSTR lpName, LPCWSTR lpType, WORD wLang);
#endif

	// \[X̃TCY擾
	DWORD	GetSize(HMODULE hModule);

	// \[X̃[h
	BOOL	Load(HMODULE hModule);

	// \[X̃bN
	LPVOID	Lock(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
