//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCSIDL.cpp
 * @brief		CSIDL t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCSIDL_CPP_

//======================================================================
// include
#include "WXCSIDL.h"

//======================================================================
// link

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in]	CSIDL	= CSIDL l(CSIDL_***)
*//***********************************************************************/
CCSIDLPathA::CCSIDLPathA(int CSIDL)
{
	SHGetFolderPathA(nullptr, CSIDL, nullptr, 0, m_Path);
}

/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in]	CSIDL	= CSIDL l(CSIDL_***)
*//***********************************************************************/
CCSIDLPathW::CCSIDLPathW(int CSIDL)
{
	SHGetFolderPathW(nullptr, CSIDL, nullptr, 0, m_Path);
}

}	// end of namespace wx
}	// end of namespace iris

