//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCommDlg.cpp
 * @brief		t@CEtH_I[v֘A
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCommDlg_CPP_

//======================================================================
// include
#include "iris_inchead.h"
#include "WXCommDlg.h"
#include "dialog/WXSHBrowseFolder.h"
#include "dialog/WXSHFileOpen.h"
#include "dialog/WXSHFileSave.h"
#include "dialog/WXSHChooseColor.h"
#include "dialog/WXSHChooseFont.h"

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * ut@CJv_CAO\
 *
 * @note	݊̂߂ɎcĂ܂B
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [in]	Filter		= tB^[ (*)"(*.txt)\0*.txt\0(*.*)\0*.*"
 * @param [out]	FileName	= t@C̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @return	t@CI@true@ 
*//***********************************************************************/
BOOL FileOpenDlg (HWND hWnd, LPCTSTR Filter, LPTSTR FileName, DWORD dwSize, DWORD Flags)
{
	OPENFILENAME OFN;
	ZeroMemory(&OFN, sizeof(OPENFILENAME));
	return FileOpenDlg(hWnd, Filter, FileName, dwSize, Flags, &OFN);
}
/// iris::wx::FileOpenDlg Q
BOOL FileOpenDlgA(HWND hWnd, LPCSTR  Filter, LPSTR  FileName, DWORD dwSize, DWORD Flags)
{
	OPENFILENAMEA OFN;
	ZeroMemory(&OFN, sizeof(OPENFILENAMEA));
	return FileOpenDlgA(hWnd, Filter, FileName, dwSize, Flags, &OFN);
}
/// iris::wx::FileOpenDlg Q
BOOL FileOpenDlgW(HWND hWnd, LPCWSTR Filter, LPWSTR FileName, DWORD dwSize, DWORD Flags)
{
	OPENFILENAMEW OFN;
	ZeroMemory(&OFN, sizeof(OPENFILENAMEW));
	return FileOpenDlgW(hWnd, Filter, FileName, dwSize, Flags, &OFN);
}

/**********************************************************************//**
 *
 * ut@CJv_CAO\
 *
 * @note	݊̂߂ɎcĂ܂B
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [in]	Filter		= tB^[
 * @param [out]	FileName	= t@C̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @param [in]	ofn			= 
 * @return	t@CI@true@ 
*//***********************************************************************/
BOOL FileOpenDlg(HWND hWnd, LPCTSTR Filter, LPTSTR FileName, DWORD dwSize, DWORD Flags, OPENFILENAME* ofn)
{
#ifdef UNICODE
	return FileOpenDlgW(hWnd, Filter, FileName, dwSize, Flags, ofn);
#else
	return FileOpenDlgA(hWnd, Filter, FileName, dwSize, Flags, ofn);
#endif
}
/// iris::wx::FileOpenDlg Q
BOOL FileOpenDlgA(HWND hWnd, LPCSTR  Filter, LPSTR  FileName, DWORD dwSize, DWORD Flags, OPENFILENAMEA* ofn)
{
	return CSHFileOpen::ShowA(hWnd, IRIS_TEXTA("t@CIĂ"), Filter, FileName, dwSize, Flags, ofn);
}
/// iris::wx::FileOpenDlg Q
BOOL FileOpenDlgW(HWND hWnd, LPCWSTR Filter, LPWSTR FileName, DWORD dwSize, DWORD Flags, OPENFILENAMEW* ofn)
{
	return CSHFileOpen::ShowW(hWnd, IRIS_TEXTW("t@CIĂ"), Filter, FileName, dwSize, Flags, ofn);
}

/**********************************************************************//**
 *
 * ut@Cۑv_CAO\
 *
 * @note	݊̂߂ɎcĂ܂B
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [in]	Filter		= tB^[
 * @param [out]	FileName	= t@C̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @return	t@CI@true@ 
*//***********************************************************************/
BOOL FileSaveDlg (HWND hWnd, LPCTSTR Filter, LPTSTR FileName, LPCTSTR defext, DWORD dwSize, DWORD Flags)
{
	OPENFILENAME OFN;
	ZeroMemory(&OFN, sizeof(OPENFILENAME));
	return FileSaveDlg (hWnd, Filter, FileName, defext, dwSize, Flags, &OFN);
}
/// iris::wx::FileSaveDlg Q
BOOL FileSaveDlgA(HWND hWnd, LPCSTR  Filter, LPSTR  FileName, LPCSTR  defext, DWORD dwSize, DWORD Flags)
{
	OPENFILENAMEA OFN;
	ZeroMemory(&OFN, sizeof(OPENFILENAMEA));
	return FileSaveDlgA(hWnd, Filter, FileName, defext, dwSize, Flags, &OFN);
}
/// iris::wx::FileSaveDlg Q
BOOL FileSaveDlgW(HWND hWnd, LPCWSTR Filter, LPWSTR FileName, LPCWSTR defext, DWORD dwSize, DWORD Flags)
{
	OPENFILENAMEW OFN;
	ZeroMemory(&OFN, sizeof(OPENFILENAMEW));
	return FileSaveDlgW(hWnd, Filter, FileName, defext, dwSize, Flags, &OFN);
}

/**********************************************************************//**
 *
 * ut@Cۑv_CAO\
 *
 * @note	݊̂߂ɎcĂ܂B
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [in]	Filter		= tB^[
 * @param [out]	FileName	= t@C̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @param [in]	ofn			= 
 * @return	t@CI@true@ 
*//***********************************************************************/
BOOL FileSaveDlg (HWND hWnd, LPCTSTR Filter, LPTSTR FileName, LPCTSTR defext, DWORD dwSize, DWORD Flags, OPENFILENAME* ofn)
{
#ifdef UNICODE
	return FileSaveDlgW(hWnd, Filter, FileName, defext, dwSize, Flags, ofn);
#else
	return FileSaveDlgA(hWnd, Filter, FileName, defext, dwSize, Flags, ofn);
#endif
}
BOOL FileSaveDlgA(HWND hWnd, LPCSTR  Filter, LPSTR  FileName, LPCSTR  defext, DWORD dwSize, DWORD Flags, OPENFILENAMEA* ofn)
{
	return CSHFileSave::ShowA(hWnd, IRIS_TEXTA("Otĕۑ"), Filter, defext, FileName, dwSize, Flags, ofn);
}
BOOL FileSaveDlgW(HWND hWnd, LPCWSTR Filter, LPWSTR FileName, LPCWSTR defext, DWORD dwSize, DWORD Flags, OPENFILENAMEW* ofn)
{
	return CSHFileSave::ShowW(hWnd, IRIS_TEXTW("Otĕۑ"), Filter, defext, FileName, dwSize, Flags, ofn);
}

/**********************************************************************//**
 *
 * utH_Jv_CAO\
 *
 * @note	݊̂߂ɎcĂ܂B
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [out]	FolderName	= tH_̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @return	tH_I@true@ 
*//***********************************************************************/
BOOL FolderOpenDlg (HWND hWnd, LPTSTR FolderName, DWORD Flags)
{
#ifdef UNICODE
	return FolderOpenDlgW(hWnd, FolderName, Flags);
#else
	return FolderOpenDlgA(hWnd, FolderName, Flags);
#endif
}
/// iris::wx::FolderOpenDlg Q
BOOL FolderOpenDlgA(HWND hWnd, LPSTR  FolderName, DWORD Flags)
{
	return CSHBrowseFolder::ShowA(hWnd, IRIS_TEXTA("tH_IĂ"), FolderName, FolderName, Flags);
}
/// iris::wx::FolderOpenDlg Q
BOOL FolderOpenDlgW(HWND hWnd, LPWSTR FolderName, DWORD Flags)
{
	return CSHBrowseFolder::ShowW(hWnd, IRIS_TEXTW("tH_IĂ"), FolderName, FolderName, Flags);
}

/**********************************************************************//**
 *
 * OpenChooseColorDlg
 *
 -----------------------------------------------------------------------
 * @param [in]	hOwner		= eEChẼnh
 * @param [out]	pResult		= IF(߂l)
 * @param [in]	pCustColors	= JX^J[z
 * @param [in]	Flags		= ݒtO
 * @return	FI@true@ 
*//***********************************************************************/
BOOL OpenChooseColorDlg(HWND hOwner, COLORREF* pResult, COLORREF* pCustColors, DWORD Flags)
{
	return CSHChooseColor::Show(hOwner, pResult, pCustColors, Flags);
}

/**********************************************************************//**
 *
 * OpenChooseFontDlg
 *
 -----------------------------------------------------------------------
 * @param [in]	hOwner		= eEChẼnh
 * @param [out]	lpLogFont	= tHg(߂l)
 * @param [out]	pColor		= tHgJ[(߂l)
 * @param [in]	SizeMin		= ŏtHgTCY
 * @param [in]	SizeMax		= őtHgTCY
 * @param [in]	Flags		= ݒtO
 * @return	tHgI@true@ 
*//***********************************************************************/
BOOL OpenChooseFontDlg(HWND hOwner, LOGFONT* lpLogFont, COLORREF* pColor, int SizeMin, int SizeMax, DWORD Flags)
{
	return CSHChooseFont::Show(hOwner, lpLogFont, SizeMin, SizeMax, Flags, pColor);
}

}	// end of namespace wx
}	// end of namespace iris
