//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDropHandle.h
 * @brief		HDROPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDropHandle_H_
#define INCG_IRIS_WXDropHandle_H_

//======================================================================
// include
#include "iris_object.h"
#include <shellapi.h>

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
//! HDROPNX
class CDropHandle : public IIrisObject
{
protected:
	HDROP	m_hDrop;	//!< nh
public:
	// RXgN^
	CDropHandle(void);
	CDropHandle(HDROP hDrop);
	// fXgN^
	~CDropHandle(void);

    // nh̎擾
	HDROP	GetDrop(void)		{ return m_hDrop; }
	HDROP	operator()(void)	{ return m_hDrop; }
	operator HDROP (void)		{ return m_hDrop; }

public:
	// ֘At
	BOOL	Attach(HDROP hDrop);
	// ֘At̉
	HDROP	Detach(void);

public:
	// I
	void	Finish(void);

public:
	// ̎擾
	UINT	QueryFile (UINT uFlags, LPTSTR lpBuffer, UINT uSize);
	UINT	QueryFileA(UINT uFlags, LPSTR  lpBuffer, UINT uSize);
	UINT	QueryFileW(UINT uFlags, LPWSTR lpBuffer, UINT uSize);

	// 
	BOOL	QueryPoint(LPPOINT lppt);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
