//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHExecute.h
 * @brief		Shell֐gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSHExecute_H_
#define INCG_IRIS_WXSHExecute_H_

//======================================================================
// include
#include "iris_object.h"
#include <shellapi.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	sNX
*/
class CSHExecute : public IIrisObject
{
public:
	static HINSTANCE	Run (HWND hwnd, LPCTSTR lpOperation, LPCTSTR lpFile, LPCTSTR lpParameters
					, LPCTSTR lpDirectory, INT nShowCmd);
	static HINSTANCE	RunA(HWND hwnd, LPCSTR  lpOperation, LPCSTR  lpFile, LPCSTR  lpParameters
					, LPCSTR  lpDirectory, INT nShowCmd);
	static HINSTANCE	RunW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters
					, LPCWSTR lpDirectory, INT nShowCmd);

	static HINSTANCE	Run (HWND hwnd, LPCTSTR lpOperation, LPCTSTR lpFile, LPCTSTR lpParameters
					, LPCTSTR lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFO  lpsei);
	static HINSTANCE	RunA(HWND hwnd, LPCSTR  lpOperation, LPCSTR  lpFile, LPCSTR  lpParameters
					, LPCSTR  lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFOA lpsei);
	static HINSTANCE	RunW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters
					, LPCWSTR lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFOW lpsei);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
