//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellLink.cpp
 * @brief		Nt@C쐬֐
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXShellLink_CPP_

//======================================================================
// include
#include "WXShellLink.h"
#include "../com/WXCom.h"
#include <shlobj.h>

//======================================================================
// link
#pragma comment( lib, "shlwapi.lib" )

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * V[gJbgt@C̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	pszLink			= V[gJbg̐΃pX
 * @param [in]	pszFile			= ^[Qbgt@C
 * @param [in]	pszDescription	= 
 * @param [in]	pszArgs			= 
 * @param [in]	pszWorkingDir	= ƃfBNg
 * @param [in]	pszIconPath		= ACȐꏊ
 * @param [in]	nIcon			= ACR̃CfbNX
 * @param [in]	nShowCmd		= EBhE\R}h
 * @return HRESULTl
*//***********************************************************************/
HRESULT CreateLinkFile (  LPCTSTR pszLink
						, LPCTSTR pszFile
						, LPCTSTR pszDescription
						, LPCTSTR pszArgs
						, LPCTSTR pszWorkingDir
						, LPCTSTR pszIconPath
						, int nIcon
						, int nShowCmd )
{
#ifdef UNICODE
	return CreateLinkFileW(pszLink
		, pszFile
		, pszDescription
		, pszArgs
		, pszWorkingDir
		, pszIconPath
		, nIcon
		, nShowCmd );
#else
	return CreateLinkFileA(pszLink
		, pszFile
		, pszDescription
		, pszArgs
		, pszWorkingDir
		, pszIconPath
		, nIcon
		, nShowCmd );
#endif
}
/// CreateLinkFile Q
HRESULT CreateLinkFileA(  LPCSTR  pszLink
						, LPCSTR  pszFile
						, LPCSTR  pszDescription
						, LPCSTR  pszArgs
						, LPCSTR  pszWorkingDir
						, LPCSTR  pszIconPath
						, int nIcon
						, int nShowCmd )
{
	HRESULT hr;
#if	!defined(IRIS_WIN32_WCE)
	IShellLinkA* psl = nullptr;
#else
	IShellLink* psl = nullptr;
#endif
	// Com
	CCom	com;
	// IShellLink IuWFNg쐬|C^擾
	hr = CoCreateInstance(CLSID_ShellLink, nullptr, CLSCTX_INPROC_SERVER,
							IID_IShellLink, (void**)&psl);
	if(FAILED(hr)) return hr;

	// V[gJbg񎟋Luɕۑ邽 IPersistFile
	// C^[tFCX̖₢킹Ȃ
	IPersistFile* ppf;
	hr = psl->QueryInterface(IID_IPersistFile, (void**)&ppf);
	if(FAILED(hr)) goto exit;

	WORD wsz[MAX_PATH];  // Unicode ւ̃obt@(MAX_PATH΂)
	psl->SetPath(pszFile);						// ^[Qbgt@C
	psl->SetDescription(pszDescription);		// 
	psl->SetArguments(pszArgs);					// 
	psl->SetWorkingDirectory(pszWorkingDir);	// ƃfBNg
	psl->SetIconLocation(pszIconPath, nIcon);	// ACR
	psl->SetShowCmd(nShowCmd);					// EBhE\R}h

	// ANSIō\悤ɂ
	MultiByteToWideChar(CP_ACP, 0, pszLink, -1, (LPWSTR)wsz, MAX_PATH);
	// V[gJbgۑ
	hr = ppf->Save((LPCOLESTR)wsz, TRUE);
	// IPersistFile ւ̃|C^J
	ppf->Release();

exit:
	// IShellLinkւ̃|C^J
	psl->Release();
    return hr;
}
/// CreateLinkFile Q
HRESULT CreateLinkFileW(  LPCWSTR pszLink
						, LPCWSTR pszFile
						, LPCWSTR pszDescription
						, LPCWSTR pszArgs
						, LPCWSTR pszWorkingDir
						, LPCWSTR pszIconPath
						, int nIcon
						, int nShowCmd )
{
	HRESULT hr;
#if	!defined(IRIS_WIN32_WCE)
	IShellLinkW* psl = nullptr;
#else
	IShellLink* psl = nullptr;
#endif
	// Com
	CCom	com;
	// IShellLink IuWFNg쐬|C^擾
	hr = CoCreateInstance(CLSID_ShellLink, nullptr, CLSCTX_INPROC_SERVER,
							IID_IShellLink, (void**)&psl);
	if(FAILED(hr)) return hr;

	// V[gJbg񎟋Luɕۑ邽 IPersistFile
	// C^[tFCX̖₢킹Ȃ
	IPersistFile* ppf;
	hr = psl->QueryInterface(IID_IPersistFile, (void**)&ppf);
	if(FAILED(hr)) goto exit;

#if	!defined(IRIS_WIN32_WCE)
	psl->SetPath(pszFile);						// ^[Qbgt@C
	psl->SetDescription(pszDescription);		// 
	psl->SetArguments(pszArgs);					// 
	psl->SetWorkingDirectory(pszWorkingDir);	// ƃfBNg
	psl->SetIconLocation(pszIconPath, nIcon);	// ACR
#else
	CHAR file[MAX_PATH];
	CHAR descript[512];
	CHAR args[1024];
	CHAR workdir[MAX_PATH];
	CHAR icon[MAX_PATH];
	wcstombs(file, pszFile, MAX_PATH);
	wcstombs(descript, pszDescription, IRIS_NumOfElements(descript));
	wcstombs(args, pszArgs, IRIS_NumOfElements(args));
	wcstombs(workdir, pszWorkingDir, MAX_PATH);
	wcstombs(icon, pszIconPath, MAX_PATH);
	psl->SetPath(file);					// ^[Qbgt@C
	psl->SetDescription(descript);		// 
	psl->SetArguments(args);			// 
	psl->SetWorkingDirectory(workdir);	// ƃfBNg
	psl->SetIconLocation(icon, nIcon);	// ACR
#endif
	psl->SetShowCmd(nShowCmd);					// EBhE\R}h

	// V[gJbgۑ
	hr = ppf->Save((LPCOLESTR)pszLink, TRUE);
	// IPersistFile ւ̃|C^J
	ppf->Release();

exit:
	// IShellLinkւ̃|C^J
	psl->Release();
    return hr;
}

}	// end of namespace wx
}	// end of namespace iris
