//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellPath.h
 * @brief		pXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXShellPath_H_
#define INCG_IRIS_WXShellPath_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// decalre
class CPathA;
class CPathW;

//======================================================================
// typedef
#ifdef UNICODE
typedef CPathW	CPath;
#else
typedef CPathA	CPath;
#endif

//======================================================================
// class
//! pXNX(multibyte)
class CPathA : public IIrisObject
{
private:
	// pXNXȂ̂Ńobt@MAX_PATHpӂȂ
	CHAR	m_Path[MAX_PATH];
public:
	// RXgN^
	CPathA(void);
	CPathA(LPCSTR  lpszPath);
	// fXgN^
	~CPathA(void);

	operator LPSTR   (void)			{ return GetPath(); }
	operator LPCSTR  (void)	const	{ return GetPath(); }
	LPSTR 	operator ()	(void)		{ return GetPath(); }
	LPCSTR 	operator ()	(void) const{ return GetPath(); }

public:

    //̎擾
	CHAR	operator [] (int nIndex) const;
	CPathA&	operator =  (LPCSTR  lpString);
	CPathA&	operator += (LPCSTR  lpString);

public:
	// Rs[
	void		Copy(LPCSTR  lpszPath);

public:
	// obNXbVǉ
	CPathA&		AddBackslash(void);
	// gqǉ
	BOOL		AddExtension(LPCSTR  pszExt);
	// t@Cǉ
	BOOL		AddFileName(LPCSTR  pszFile);
	// pX̌
	BOOL		Append(LPCSTR  pszMore);
	// hCu[gpX̎擾
	BOOL		BuildRoot(int iDrive);
	// pX . A .. 폜
	BOOL		Canonicalize(void);
	BOOL		Canonicalize(LPCSTR  pszPath);
	// fBNgƃt@CpX̌
	BOOL		Combine(LPCSTR  pszDir, LPCSTR  pszFile);
	BOOL		CombineDirectory(LPCSTR  pszDir);
	BOOL		CombineFile(LPCSTR  pszFile);
	// \̈Ɏ܂pXɕϊ
	BOOL		CompactPath(HDC hDC, int dx);
	// \̈Ɏ܂pXɕϊ
	BOOL		CompactPathEx(UINT cchMax, DWORD dwFlags);
	BOOL		CompactPathEx(LPSTR  pszDst, UINT cchMax, DWORD dwFlags);
	// Q̃pX狤ʂ̃pXo
	BOOL		CommonPrefix(LPCSTR  pszFile1, LPCSTR  pszFile2);
#if	!defined(IRIS_WIN32_WCE)
	// pXWJpXɕϊ
	DWORD		ExpandEnvStrings(LPCSTR  lpSrc);
#endif
	// t@C݂邩ǂ
	BOOL		FileExists(void);
	// gq
	LPSTR 		FindExtension(void);
	// t@C
	LPSTR 		FindFileName(void);
	// ̍\vf
	LPSTR 		FindNextComponent(void);
	// Ō̍\vf
	LPSTR 		FindLastComponent(void);
	// WpXEPathst@C
	BOOL		FindOnPath(LPSTR  pszPath, LPCSTR * ppszOtherDirs);
	// TtBbNX̌
	LPCSTR 		FindSuffixArray(LPCSTR * lppSuffix, int nArraySize);
	// ̕񂩂R}hC擾
	LPSTR 		GetArgs(void);
	// hCuԍ̎擾
	int			GetDriveNumber(void);
	// ̃Rec^Cvǂ
	BOOL		IsContentType(LPCSTR  pszContentType);
	// fBNg݂邩ǂ
	BOOL		IsDirectory(void);
	// fBNg󂩂ǂ
	BOOL		IsDirectoryEmpty(void);
	// ؂蕶邩ǂ
	BOOL		IsFileSpec(void);
	// pXtH[}bgǂ
	BOOL		IsLFNFileSpec(void);
	// lbg[ÑpXǂ
	BOOL		IsNetworkPath(void);
	// pX̕񂩂n܂Ă邩ǂ
	BOOL		IsPrefix(LPCSTR  pszPrefix);
	// pX΃pXǂ
	BOOL		IsRelative(void);
	// pX[gpXǂ
	BOOL		IsRoot(void);
	// pX̃[gpXǂ
	BOOL		IsSameRoot(LPCSTR  pszPath);
	// pXVXet@Cǂ
	BOOL		IsSystemFolder(void);
	// pXUNC\Lł邩ǂ
	BOOL		IsUNC(void);
	// pXT[o[\UNC\Lł邩ǂ
	BOOL		IsUNCServer(void);
	// pXT[o[\UNC\Lł邩ǂ
	BOOL		IsUNCServerShare(void);
	// pXURL\Lł邩ǂ
	BOOL		IsURL(void);
	// 啶̃pXɕϊ
	BOOL		MakePretty(void);
	// t@CVXet@Cɂ
	BOOL		MakeSystemFolder(void);
	// pXɈv邩
	BOOL		MatchSpec(LPCSTR  pszSpec);
	// 󔒂pX '"' 
	void		QuoteSpaces(void);
	// ̃pXԂ̑΃pX擾
	BOOL		RelativePathTo(LPCSTR  pszFrom, DWORD dwAttrFrom, LPCSTR  pszTo, DWORD dwAttrTo);
	// obNXbV폜
	LPSTR 		RemoveBackslash(void);
	// pX̑Ő󔒂폜
	void		RemoveBlanks(void);
	// pXgq폜
	void		RemoveExtension(void);
	// pXt@C폜
	BOOL		RemoveFileSpec(void);
	// pX̊gqύX
	BOOL		RenameExtension(LPCSTR  pszExt);
	// tpX߂
	BOOL		SearchAndQualify(LPSTR  pszBuf, UINT cchBuf);
	BOOL		SearchAndQualify(LPCSTR  pszPath);
	// k߂`̃pXRg[ɕ\
	void		SetDlgItemPath(HWND hDlg, int id);
	// pX狤L폜
	LPSTR 		SkipRoot(void);
	// pXt@Co
	void		StripPath(void);
	// pX烋[gpXo
	BOOL		StripToRoot(void);
	// pXϐgppXɕύX
	BOOL		UnExpandEnvStrings(LPSTR  pszBuf, UINT cchBuf);
	// pXC폜
	void		Undecorate(void);
	// t@CVXet@CłȂ
	BOOL		UnmakeSystemFolder(void);
	// pX̑Õ_uNH[e[V폜
	void		UnquoteSpaces(void);
	
public:
	LPSTR 		GetPath(void)		{ return m_Path; }				//!< pX擾
	LPCSTR 		GetPath(void) const	{ return m_Path; }				//!< pX擾
	size_t		GetSize(void)		{ return sizeof(m_Path); }		//!< obt@TCY擾
	size_t		GetLength(void)		{ return MAX_PATH; }			//!< 񒷂擾

public:
	// original function
	// t@CɎgȂ폜
	BOOL		FormatFileName(LPCSTR  pszFile, s32 max_len);


public:
	// static function
	//  m_PathgpKvȂ̂
	// t@C݂邩ǂ
	static	BOOL		FileExists(LPCSTR  pszPath);
	// ̍\vf
	static	LPSTR 		FindNextComponent(LPCSTR  pszPath);
	// ̕񂩂R}hC擾
	static	LPSTR 		GetArgs(LPCSTR  pszPath);
	// pX\镶̎ʂ𔻒
	static	UINT		GetCharType(UCHAR ch);
	// ̃t@CVXet@Cǂ
	static	BOOL		IsSystemFolder(DWORD dwAttrb);
	// ACRpXt@CpXƃCfbNX擾
	static	int			ParseIconLocation(LPSTR  pszIconFile);
	// R}hC폜
	static	void		RemoveArgs(LPSTR  pszPath);

};

//! pXNX(unicode)
class CPathW : public IIrisObject
{
private:
	// pXNXȂ̂Ńobt@MAX_PATHpӂȂ
	WCHAR	m_Path[MAX_PATH];
public:
	// RXgN^
	CPathW(void);
	CPathW(LPCWSTR lpszPath);
	// fXgN^
	~CPathW(void);

	operator LPWSTR  (void)			{ return GetPath(); }
	operator LPCWSTR (void)	const	{ return GetPath(); }
	LPWSTR	operator ()	(void)		{ return GetPath(); }
	LPCWSTR	operator ()	(void) const{ return GetPath(); }

public:

    //̎擾
	WCHAR	operator [] (int nIndex) const;
	CPathW&	operator =  (LPCWSTR lpString);
	CPathW&	operator += (LPCWSTR lpString);

public:
	// Rs[
	void		Copy(LPCWSTR lpszPath);

public:
	// obNXbVǉ
	CPathW&		AddBackslash(void);
	// gqǉ
	BOOL		AddExtension(LPCWSTR pszExt);
	// t@Cǉ
	BOOL		AddFileName(LPCWSTR pszFile);
	// pX̌
	BOOL		Append(LPCWSTR pszMore);
	// hCu[gpX̎擾
	BOOL		BuildRoot(int iDrive);
	// pX . A .. 폜
	BOOL		Canonicalize(void);
	BOOL		Canonicalize(LPCWSTR pszPath);
	// fBNgƃt@CpX̌
	BOOL		Combine(LPCWSTR pszDir, LPCWSTR pszFile);
	BOOL		CombineDirectory(LPCWSTR pszDir);
	BOOL		CombineFile(LPCWSTR pszFile);
	// \̈Ɏ܂pXɕϊ
	BOOL		CompactPath(HDC hDC, int dx);
	// \̈Ɏ܂pXɕϊ
	BOOL		CompactPathEx(UINT cchMax, DWORD dwFlags);
	BOOL		CompactPathEx(LPWSTR pszDst, UINT cchMax, DWORD dwFlags);
	// Q̃pX狤ʂ̃pXo
	BOOL		CommonPrefix(LPCWSTR pszFile1, LPCWSTR pszFile2);
#if	!defined(IRIS_WIN32_WCE)
	// pXWJpXɕϊ
	DWORD		ExpandEnvStrings(LPCWSTR lpSrc);
#endif
	// t@C݂邩ǂ
	BOOL		FileExists(void);
	// gq
	LPWSTR		FindExtension(void);
	// t@C
	LPWSTR		FindFileName(void);
	// ̍\vf
	LPWSTR		FindNextComponent(void);
	// Ō̍\vf
	LPWSTR		FindLastComponent(void);
	// WpXEPathst@C
	BOOL		FindOnPath(LPWSTR pszPath, LPCWSTR* ppszOtherDirs);
	// TtBbNX̌
	LPCWSTR		FindSuffixArray(LPCWSTR* lppSuffix, int nArraySize);
	// ̕񂩂R}hC擾
	LPWSTR		GetArgs(void);
	// hCuԍ̎擾
	int			GetDriveNumber(void);
	// ̃Rec^Cvǂ
	BOOL		IsContentType(LPCWSTR pszContentType);
	// fBNg݂邩ǂ
	BOOL		IsDirectory(void);
	// fBNg󂩂ǂ
	BOOL		IsDirectoryEmpty(void);
	// ؂蕶邩ǂ
	BOOL		IsFileSpec(void);
	// pXtH[}bgǂ
	BOOL		IsLFNFileSpec(void);
	// lbg[ÑpXǂ
	BOOL		IsNetworkPath(void);
	// pX̕񂩂n܂Ă邩ǂ
	BOOL		IsPrefix(LPCWSTR pszPrefix);
	// pX΃pXǂ
	BOOL		IsRelative(void);
	// pX[gpXǂ
	BOOL		IsRoot(void);
	// pX̃[gpXǂ
	BOOL		IsSameRoot(LPCWSTR pszPath);
	// pXVXet@Cǂ
	BOOL		IsSystemFolder(void);
	// pXUNC\Lł邩ǂ
	BOOL		IsUNC(void);
	// pXT[o[\UNC\Lł邩ǂ
	BOOL		IsUNCServer(void);
	// pXT[o[\UNC\Lł邩ǂ
	BOOL		IsUNCServerShare(void);
	// pXURL\Lł邩ǂ
	BOOL		IsURL(void);
	// 啶̃pXɕϊ
	BOOL		MakePretty(void);
	// t@CVXet@Cɂ
	BOOL		MakeSystemFolder(void);
	// pXɈv邩
	BOOL		MatchSpec(LPCWSTR pszSpec);
	// 󔒂pX '"' 
	void		QuoteSpaces(void);
	// ̃pXԂ̑΃pX擾
	BOOL		RelativePathTo(LPCWSTR pszFrom, DWORD dwAttrFrom, LPCWSTR pszTo, DWORD dwAttrTo);
	// obNXbV폜
	LPWSTR		RemoveBackslash(void);
	// pX̑Ő󔒂폜
	void		RemoveBlanks(void);
	// pXgq폜
	void		RemoveExtension(void);
	// pXt@C폜
	BOOL		RemoveFileSpec(void);
	// pX̊gqύX
	BOOL		RenameExtension(LPCWSTR pszExt);
	// tpX߂
	BOOL		SearchAndQualify(LPWSTR pszBuf, UINT cchBuf);
	BOOL		SearchAndQualify(LPCWSTR pszPath);
	// k߂`̃pXRg[ɕ\
	void		SetDlgItemPath(HWND hDlg, int id);
	// pX狤L폜
	LPWSTR		SkipRoot(void);
	// pXt@C폜
	void		StripPath(void);
	// pX烋[gpX폜
	BOOL		StripToRoot(void);
	// pXϐgppXɕύX
	BOOL		UnExpandEnvStrings(LPWSTR pszBuf, UINT cchBuf);
	// pXC폜
	void		Undecorate(void);
	// t@CVXet@CłȂ
	BOOL		UnmakeSystemFolder(void);
	// pX̑Õ_uNH[e[V폜
	void		UnquoteSpaces(void);
	
public:
	LPWSTR		GetPath(void)		{ return m_Path; }				//!< pX擾
	LPCWSTR		GetPath(void) const	{ return m_Path; }				//!< pX擾
	size_t		GetSize(void)		{ return sizeof(m_Path); }		//!< obt@TCY擾
	size_t		GetLength(void)		{ return MAX_PATH; }			//!< 񒷂擾

public:
	// original function
	// t@CɎgȂ폜
	BOOL		FormatFileName(LPCWSTR pszFile, s32 max_len);


public:
	// static function
	//  m_PathgpKvȂ̂
	// t@C݂邩ǂ
	static	BOOL		FileExists(LPCWSTR pszPath);
	// ̍\vf
	static	LPWSTR		FindNextComponent(LPCWSTR pszPath);
	// ̕񂩂R}hC擾
	static	LPWSTR		GetArgs(LPCWSTR pszPath);
	// pX\镶̎ʂ𔻒
	static	UINT		GetCharType(WCHAR ch);
	// ̃t@CVXet@Cǂ
	static	BOOL		IsSystemFolder(DWORD dwAttrb);
	// ACRpXt@CpXƃCfbNX擾
	static	int			ParseIconLocation(LPWSTR pszIconFile);
	// R}hC폜
	static	void		RemoveArgs(LPWSTR pszPath);

};


}	// end of namespace wx
}	// end of namespace iris

#endif
