//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMSXMLNode.h
 * @brief		MSXML Node t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMSXMLNode_H_
#define INCG_IRIS_WXMSXMLNode_H_

//======================================================================
// include
#include "iris_object.h"

#ifdef _IRIS_SUPPORT_MSXML

#include "msxml3.tlh"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	MS XML Node NX
*/
class CMSXmlNode : public IIrisObject
{
public:
	typedef MSXML2::IXMLDOMDocumentPtr	IDocumentPtr;
	typedef MSXML2::IXMLDOMNodePtr		INodePtr;
	typedef MSXML2::IXMLDOMNodeListPtr	INodeListPtr;
	typedef MSXML2::IXMLDOMElementPtr	IElementPtr;
	typedef MSXML2::IXMLDOMAttributePtr	IAttributePtr;

private:
	INodePtr	m_Node;	//!< m[h
public:
	// RXgN^
	CMSXmlNode(INodePtr node);
	// fXgN^
	~CMSXmlNode(void);

public:
	// qm[h̒ǉ
	INodePtr		AddChild(LPCTSTR lpszNodeName, LPCTSTR lpszText);
	// qm[h̍폜
	BOOL			RemoveChild(LPCTSTR lpszNodeName);
	BOOL			RemoveChild(INodePtr node);

	// qm[h̎擾
	INodePtr		GetChild(LPCTSTR lpszNodeName);
	INodePtr		GetChild(INT nIndex);

public:
	// ̐ݒ
	BOOL			SetAttribute(LPCTSTR lpszAttribute, LPCTSTR lpszValue);
	// ̎擾
	BOOL			GetAttribute(LPCTSTR lpszAttribute, LPCTSTR lpszDefault, LPTSTR lpszValue, DWORD dwSize);

public:
	INodePtr::Interface* operator -> (void)	{ return m_Node; }
	operator INodePtr (void) { return m_Node; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
