//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqSystem.h
 * @brief		squirrel t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_SqSystem_H_
#define INCG_IRIS_SqSystem_H_

//======================================================================
// include
#include "sq_inchead.h"
#include "../../iris_variant.hpp"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// class
/// squirrel NX
class CSquirrel : public INonCopyable<>
{
public:
	/// ֐R[pNX
	class Functor : public IIrisObject
	{
	private:
		CSquirrel&	m_sq;	//!< squirrel
		SQInteger m_top;	//!< top
		int	m_args;	//!< ̐
	public:
		// RXgN^
		Functor(CSquirrel& sq, LPCSQSTR lpName);
		Functor(Functor& obj)
			: m_sq(obj.m_sq), m_top(obj.m_top), m_args(obj.m_args)
		{}
	public:
		// Zbg
		Functor&	PushInteger(SQInteger n)					{ if( m_args >= 0 ) { ++m_args; m_sq.PushInteger(n); } return *this; }
		Functor&	PushBool(SQBool b)							{ if( m_args >= 0 ) { ++m_args; m_sq.PushBool(b); } return *this; }
		Functor&	PushFloat(SQFloat f)						{ if( m_args >= 0 ) { ++m_args; m_sq.PushFloat(f); } return *this; }
		Functor&	PushPointer(SQUserPointer p)				{ if( m_args >= 0 ) { ++m_args; m_sq.PushPointer(p); } return *this; }
		Functor&	PushString(const SQChar* s, SQInteger len)	{ if( m_args >= 0 ) { ++m_args; m_sq.PushString(s, len); } return *this; }
	public:
		// Ăяo
		SQRESULT	Call(void);
	};
private:
	HSQUIRRELVM	m_VM;	//!< z}V

public:
	// RXgN^
	CSquirrel(void);
	CSquirrel(HSQUIRRELVM vm);
	// fXgN^
	~CSquirrel(void);

public:
	// z}VJ
	void		Open(SQInteger initialstacksize=2048);
	// z}V
	void		Close(void);

public:
	// XNvg̃RpCƎs
	SQRESULT	DoFile(LPCSQSTR lpFile, SQBool retVal, SQBool printerror);
	
public:
	// ֐̎s
	SQRESULT	Exec(LPCSQSTR lpName, int num, ...);
	// ֐̌ĂяoGg
	Functor		Func(LPCSQSTR lpName);
	// ֐̓o^
	SQRESULT	RegisterFunction(SQFUNCTION func, LPCSQSTR lpName);

public:
	/// z}V̎擾
	HSQUIRRELVM	GetVM(void)	{ return m_VM; }
public:
	// wrap
	SQInteger	GetTop(void)				{ return sq_gettop(m_VM); }
	void		SetTop(SQInteger newtop)	{ sq_settop(m_VM, newtop); }
	SQRESULT	Get(SQInteger idx)			{ return sq_get(m_VM, idx); }
	void		Push(SQInteger idx)			{ sq_push(m_VM, idx); }
	void		Pop(SQInteger nelemstopop)	{ sq_pop(m_VM, nelemstopop); }
	void		PushInteger(SQInteger n)	{ sq_pushinteger(m_VM, n); }
	void		PushBool(SQBool b)			{ sq_pushbool(m_VM, b); }
	void		PushFloat(SQFloat f)		{ sq_pushfloat(m_VM, f); }
	void		PushNull(void)				{ sq_pushnull(m_VM); }
	void		PushRootTable(void)			{ sq_pushroottable(m_VM); }
	void		PushPointer(SQUserPointer p){ sq_pushuserpointer(m_VM, p); }
	SQInteger	GetVMState(void)			{ return sq_getvmstate(m_VM); }
	void		PushString(const SQChar* s, SQInteger len)					{ sq_pushstring(m_VM, s, len); }
	SQRESULT	Call(SQInteger params, SQBool retval, SQBool raiseerror)	{ return sq_call(m_VM, params, retval, raiseerror); }
	HSQUIRRELVM	NewThread(SQInteger initialstacksize)						{ return sq_newthread(m_VM, initialstacksize); }

public:
	/**
	 * @brief	[eBeB
	*/
	class Utility : public IIrisObject
	{
	public:
		// _v֐
		static	SQInteger	DumpArgs(HSQUIRRELVM vm);
	};
};

}	// end of namespace sq
}	// end of namespace iris

#endif

#endif
