//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		STLvecmap.h
 * @brief		vector map t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_STLvecmap_H_
#define INCG_IRIS_STLvecmap_H_

//======================================================================
// include
#include "iris_object.h"
#include <vector>

namespace iris {
namespace stl
{

//======================================================================
// class
//! 2vfvector
template<typename _Key, typename _Val>
class vecmap : public std::vector< std::pair<_Key,_Val> >
{
	typedef typename vecmap< _Key,_Val >					_Myt;
	typedef typename std::vector< std::pair<_Key,_Val> >	_Mybase;
public:
	// find
	_Mybase::iterator			find(const _Key &key)
	{
		_Mybase::iterator it = begin(), last = end();
		for( ; it != last; ++it )
		{
			if( it->first == key ) return it;
		}
		return last;
	}
	_Mybase::const_iterator	find(const _Key &key) const
	{
		_Mybase::const_iterator it = begin(), last = end();
		for( ; it != last; ++it )
		{
			if( it->first == key ) return it;
		}
		return last;
	}
};

}	// end of namespace stl
}	// end of namespace iris

#endif
