//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitCore.cpp
 * @brief		Unit Core t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_UnitCore_CPP_

//======================================================================
// include
#include "UnitCore.h"
#include "gt/gt_inchead.h"
#include "iris_global.h"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

namespace iris {
namespace unit
{

}	// end of namespace unit
}	// end of namespace iris

#ifdef _IRIS_MULTI_UNITTEST

//======================================================================
// typedef
#if		defined(IRIS_WIN32)
#  include "target/UnitMultiUnitTest_WIN32.h"
#  ifdef _IRIS_SUPPORT_MULTI_UNITTEST_GUI
typedef iris::unit::CMultiUnitTester_WIN32GUI	CMUT;
#  else
typedef iris::unit::CMultiUnitTester_WIN32		CMUT;
#  endif
#else
#include "target/UnitMultiUnitTest.h"
typedef iris::unit::CMultiUnitTester			CMUT;
#endif
#include <tchar.h>

#endif	// #ifdef _IRIS_MULTI_UNITTEST

//======================================================================
// function
/**********************************************************************//**
 *
 * P̃eXgGg[|Cg
 * 
 ----------------------------------------------------------------------
 * @return	int
*//***********************************************************************/
EXTERN_C int Iris_UnitTest_Main(void)
{
	int ret = 0;
#ifdef _IRIS_MULTI_UNITTEST
	CMUT mut;
	bool all = false;
	if( !mut.Initialize() )
	{
		fprintf(stderr, "multi unit test initialize failed.\n");
		return 0;
	}

	mut.PutsFirstText();
	fprintf(stderr, "-------------------------------------------------------------------\n");
	if( __argc > 1 )
	{
		for( int i=0; i < __argc; ++i )
		{
			if( _tcscmp( __targv[i], IRIS_TEXT("all") ) == 0 )
			{
				mut.RunAll();
				all = true;
			}
			else
			{
				// TODO : eXgsł悤ɂB
			}
		}
	}

	if( !all )
		mut.Run();
	mut.Release();
#else
#if	defined(_IRIS_SUPPORT_GOOGLETEST)
#if	 defined(_WIN32) && !defined(_CONSOLE)
	AllocConsole();
#endif
	int argc = ::irisGetArgc();
	LPSTR* argv = ::irisGetArgv();

	GT_INIT(&argc, argv);
	RUN_ALL_TESTS();

#endif

#ifdef _IRIS_UNITTEST_FUNC
	_IRIS_UNITTEST_FUNC();
#endif

#if	defined(_IRIS_SUPPORT_GOOGLETEST)
#if	 defined(_WIN32) && !defined(_CONSOLE)
	FreeConsole();
#endif
#endif

#endif

	return ret;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )
