//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitMultiUnitTest.cpp
 * @brief		Multi Unit Test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_UnitMultiUnitTest_CPP_

//======================================================================
// include
#include "UnitMultiUnitTest.h"

#ifdef _IRIS_MULTI_UNITTEST
#include "../../iris_iostream.h"
#include "../../iris_debug.h"
#include "../../iris_main.h"
#include "../../iris_global.h"
#include "../gt/gt_inchead.h"

namespace iris {
namespace unit
{

//======================================================================
// typedef

//======================================================================
// static
CMultiUnitTester::UTMap CMultiUnitTester::s_UTMap;

//======================================================================
// class
// 
bool	CMultiUnitTester::Initialize(void)
{
	// Xgo^
	IUnitTestFuctory* p = *IUnitTestFuctory::GetRegister();
	while(p)
	{
		s_UTMap.insert(UTPair(p->m_name, p));
		p = p->m_next;
	}
	return true;
}

// s
void	CMultiUnitTester::Run(void)
{
	while(1)
	{
		if( !UpdateCommand() ) break;
	}
}

// s
void	CMultiUnitTester::RunAll(void)
{
	for( UTMap::iterator it = s_UTMap.begin(), end = s_UTMap.end(); it != end; ++it )
	{
		// s
		fprintf(stderr, "execute unit test. <%s>.\n", it->first.c_str() );
		it->second->Exec();
#ifdef _WIN32
		FlushConsoleInputBuffer( GetStdHandle(STD_INPUT_HANDLE) );
#endif
		fprintf(stderr, "done unit test. <%s>.\n", it->first.c_str() );
	}
}

// NeLXg̏o
void	CMultiUnitTester::PutsFirstText(void)
{
	fprintf(stderr, "Please input the tested file name.\n");
	fprintf(stderr, "If \"list\" is input, the registered test name is displayed.\n");
	fprintf(stderr, "If \"quite\" is input, it ends.\n");
}

// t@C̍œK
void	CMultiUnitTester::FileNameOptimize(char* fname, int length)
{
	IRIS_UNUSED_VARIABLE(fname);
	IRIS_UNUSED_VARIABLE(length);
}

// R}h
bool	CMultiUnitTester::Command(char* cmd, int size)
{
	IRIS_ASSERT( size > 4 );
	IRIS_UNUSED_VARIABLE(size);
	// Ȃɂsꍇ́AtrueԂ
	if( cmd[0] == 'n' && cmd[1] == 'o' && cmd[2] == 'n' && cmd[3] == 'e' && cmd[4] == '\0' ) return true;
	return false;
}

bool CMultiUnitTester::UpdateCommand(void)
{
	char name[MAX_PATH] = "none";
	fprintf(stderr, "> %s\n", m_curr_dir);
	std::cin >> name;
	// R}h
	if( Command(name, MAX_PATH) )
	{
		return true;
	}

	// DIɏ
	if( strcmp(name, "quite") == 0 ) return false;
	if( strcmp(name, "list") == 0 )
	{
		// Xg\
#ifdef _IRIS_DEBUG
		fprintf(stderr, "%d.\n", s_UTMap.size() );
#endif
		for( UTMap::iterator _it=s_UTMap.begin(), _end=s_UTMap.end(); _it != _end; ++_it )
		{
			fprintf(stderr, "%s\n", _it->first.c_str());
		}
		return true;
	}
	if( strcmp(name, "main") == 0 )
	{
		iris_main();
		return true;
	}
#ifdef _IRIS_SUPPORT_GOOGLETEST
	if( strcmp(name, "googletest") == 0 )
	{
		int argc = ::irisGetArgc();
		LPSTR* argv = ::irisGetArgv();

		GT_INIT(&argc, argv);
		RUN_ALL_TESTS();
		return true;
	}
#endif

	// ̍œK
	FileNameOptimize(name, (int)strlen(name));

	// P̃eXg
	UTMap::iterator end = s_UTMap.end();
	//iterator it = fnd::dbg::s_UTMap.find(name);
	UTMap::iterator it = end;
	if( it == end )
	{
		// Ov
		bool many = false;
		for( UTMap::iterator tmp = s_UTMap.begin(); tmp != end; ++tmp )
		{
			const char* p = tmp->first.c_str();
			if( strstr( p, name ) == p )
			{
				if( it == end )
				{
					it = tmp;
				}
				else
				{
					fprintf(stderr, "%s\n", it->first.c_str() );
					it = tmp;
					many = true;
				}
			}
		}
		if( many )
		{
			// ₪ꍇ
			fprintf(stderr, "%s\n", it->first.c_str() );
			return true;
		}
	}
	if( it != end )
	{
		// s
		fprintf(stderr, "execute unit test. <%s>.\n", it->first.c_str() );
		it->second->Exec();
#ifdef _WIN32
		FlushConsoleInputBuffer( GetStdHandle(STD_INPUT_HANDLE) );
#endif
		fprintf(stderr, "done unit test. <%s>.\n", it->first.c_str() );
	}
	else
	{
		fprintf(stderr, "failed unit test. <%s>.\n", name);
	}
	return true;
}

}	// end of namespace unit
}	// end of namespace iris

#endif
