//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitMultiUnitTest.h
 * @brief		Multi Unit Test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_UnitMultiUnitTest_H_
#define INCG_IRIS_UnitMultiUnitTest_H_

//======================================================================
// include
#include "../UnitFuctory.h"

#ifdef _IRIS_MULTI_UNITTEST
#include <map>
#include <string>

namespace iris {
namespace unit
{

//======================================================================
// class
// multi unit test ǗNX
class CMultiUnitTester : public iris::IIrisObject
{
public:
	typedef std::map <std::string, IUnitTestFuctory*> UTMap;
	typedef std::pair<std::string, IUnitTestFuctory*> UTPair;
protected:
	static UTMap	s_UTMap;
public:
	char m_curr_dir[MAX_PATH];
public:
	// RXgN^
	CMultiUnitTester(void)	{ m_curr_dir[0] = '\0'; }
	// fXgN^
	virtual ~CMultiUnitTester(void)	{ Release(); }

public:
	// 
	virtual bool	Initialize(void);
	// 
	virtual void	Release(void)	{}

public:
	// s
	virtual void	Run(void);
	// XV
	virtual bool	UpdateCommand(void);
	// s
	virtual void	RunAll(void);

public:
	// NeLXg̏o
	virtual void	PutsFirstText(void);
	// t@C̍œK
	virtual void	FileNameOptimize(char* fname, int length);
	// R}h
	virtual bool	Command(char* cmd, int size);
};

	
}	// end of namespace unit
}	// end of namespace iris

#endif

#endif
