//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitMultiUnitTest_WIN32.h
 * @brief		Multi Unit Test Windows t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_UnitMultiUnitTest_WIN32_H_
#define INCG_IRIS_UnitMultiUnitTest_WIN32_H_

//======================================================================
// include
#include "UnitMultiUnitTest.h"

#ifdef _IRIS_MULTI_UNITTEST
#if		defined(IRIS_WIN32)

namespace iris {
namespace unit 
{

//======================================================================
// class
// win32 p
class CMultiUnitTester_WIN32 : public CMultiUnitTester
{
protected:
#ifndef _CONSOLE
	HANDLE	m_hConsole;
#endif
public:
	FILE*	m_stdout;
	FILE*	m_stdin;
	FILE*	m_stderr;

public:
	// RXgN^
	CMultiUnitTester_WIN32(void) 
		: m_stdout(nullptr)
		, m_stdin(nullptr)
		, m_stderr(nullptr)
#ifndef _CONSOLE
		, m_hConsole(nullptr) 
#endif
	{}
public:
	// 
	virtual bool	Initialize(void);

	// 
	virtual void	Release(void);
public:
	// NeLXg̏o
	virtual void	PutsFirstText(void);
	// t@C̍œK
	virtual void	FileNameOptimize(char* fname, int length);
	// R}h
	virtual bool	Command(char* cmd, int size);
};

// user interface
#ifdef _IRIS_SUPPORT_MULTI_UNITTEST_GUI
class CMultiUnitTester_WIN32GUI : public CMultiUnitTester_WIN32
{
private:
	HWND	m_hWnd;			//!< EBhEnh
	HANDLE	m_hThread;
	DWORD	m_dwThreadId;
	WORD	m_Atom;	
public:
	// RXgN^
	CMultiUnitTester_WIN32GUI(void) : m_hWnd(nullptr), m_Atom(0), m_hThread(nullptr) {}

public:
	// NeLXg̏o
	virtual void	PutsFirstText(void)
	{
		CMultiUnitTester::PutsFirstText();
	}
	// 
	virtual bool	Initialize(void);

	// 
	virtual void	Release(void);

	// s
	virtual void	Run(void);
	// s
	virtual void	RunAll(void);
	// s
	virtual void	BaseRunAll(void);

	// ~
	void	Stop(void);

	static DWORD WINAPI Entry(void *arg);
	static DWORD WINAPI EntryAll(void *arg);
};
#endif

	
}	// end of namespace unit
}	// end of namespace iris

#endif

#endif

#endif
