//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XFConst.h
 * @brief		Œ菭萔 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_XFConst_H_
#define INCG_IRIS_XFConst_H_

//======================================================================
// include
#include "../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// static const
static const xf32 MATH_XF32_E			= XF32_CONST(MATH_F32_E);			//!< e
static const xf32 MATH_XF32_LOG2E		= XF32_CONST(MATH_F32_LOG2E);		//!< log2(e);
static const xf32 MATH_XF32_LOG10E		= XF32_CONST(MATH_F32_LOG10E);		//!< log10(e);
static const xf32 MATH_XF32_LN2			= XF32_CONST(MATH_F32_LN2);			//!< ln(2);
static const xf32 MATH_XF32_LN10		= XF32_CONST(MATH_F32_LN10);		//!< ln(10);
static const xf32 MATH_XF32_PI			= XF32_CONST(MATH_F32_PI);			//!< pi
static const xf32 MATH_XF32_2PI			= XF32_CONST(MATH_F32_PI)*2;		//!< 2 * pi
static const xf32 MATH_XF32_PI_2		= XF32_CONST(MATH_F32_PI_2);		//!< pi / 2
static const xf32 MATH_XF32_PI_4		= XF32_CONST(MATH_F32_PI_4);		//!< pi / 4
static const xf32 MATH_XF32_3PI_4		= XF32_CONST(MATH_F32_3PI_4);		//!< 3 * pi / 4
static const xf32 MATH_XF32_SQRTPI		= XF32_CONST(MATH_F32_SQRTPI);		//!< squrt(pi);
static const xf32 MATH_XF32_1_PI		= XF32_CONST(MATH_F32_1_PI);		//!< 1 / pi
static const xf32 MATH_XF32_2_PI		= XF32_CONST(MATH_F32_2_PI);		//!< 2 / pi
static const xf32 MATH_XF32_2_SQRTPI	= XF32_CONST(MATH_F32_2_SQRTPI);	//!< 2 / squrt(pi);
static const xf32 MATH_XF32_SQRT2		= XF32_CONST(MATH_F32_SQRT2);		//!< squrt(2);
static const xf32 MATH_XF32_1_SQRT2		= XF32_CONST(MATH_F32_1_SQRT2);		//!< 1 / squrt(2);
static const xf32 MATH_XF32_SQRT3		= XF32_CONST(MATH_F32_SQRT3);		//!< squrt(3);
static const xf32 MATH_XF32_SQRT3_2		= XF32_CONST(MATH_F32_SQRT3_2);		//!< squrt(3); / 2

static const xf32 MATH_XF32_IVLN10		= XF32_CONST(MATH_F32_IVLN10);		//!< 1 / log(10);
static const xf32 MATH_XF32_INVLN2		= XF32_CONST(MATH_F32_INVLN2);		//!< 1 / log(2);
static const xf32 MATH_XF32_LOG10N2		= XF32_CONST(MATH_F32_LOG10N2);		//!< log10(2);
static const xf32 MATH_XF32_LOG2N10		= XF32_CONST(MATH_F32_LOG2N10);		//!< log2(10);

static const xf32 MATH_XF32_EPSIRON		= XF32_CONST(MATH_F32_EPSIRON);		//!< 

}	// end of namespace math
}	// end of namespace iris

#endif

#endif
