//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XFHermiteCurve.cpp
 * @brief		xf32 G~[gȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_XFHermiteCurve_CPP_

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "XFHermiteCurve.h"
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CXFHermiteCurveUnitTest, XFHermiteCurveUnitTest)
{
	xf32 P0 = XF32_CONST(1.0f);
	xf32 P1 = XF32_CONST(3000.0f);
	xf32 T0 = XF32_CONST(10.0f);
	xf32 T1 = XF32_CONST(300.0f);

	for( int i=0; i < 11; ++i )
	{
		std::cout << XF_HermiteCurve(P0, T0, P1, T1, XF32_CONST(i/10.0f)) << std::endl;
	}
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
