//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XFPolynomial.h
 * @brief		xf32 w֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_XFPolynomial_H_
#define INCG_IRIS_XFPolynomial_H_

//======================================================================
// include
#include "../../math/MathPractical.h"
#include "../XFPower.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
STATICINLINE xf32	XF_BernsteinPolynomial(s32 n, s32 i, xf32 t);
STATICINLINE xf32	XF_BSplinePolynomial(s32 n, s32 i, xf32 t, xf32 nv[]);

//======================================================================
// function

//======================================================================
// inline function
/**
 * @brief	o[X^C֐
 * @param [in]	n = 
 * @param [in]	i = 
 * @param [in]	t = (0 < t < 1)
 * @return	
*/
STATICINLINE xf32		XF_BernsteinPolynomial(s32 n, s32 i, xf32 t)
{
	xf32 it = XF32_ONE - t;
	s32 c = ::iris::math::Combination(n, i);
	return c * XF32_Mul( XF_Pow(t, i), XF_Pow(it, n-i));
}

/**
 * @brief	B-XvC֐
 * @param [in]	n	= 
 * @param [in]	i	= 
 * @param [in]	t	= 
 * @param [in]	nv	= 
 * @return	
*/
STATICINLINE xf32		XF_BSplinePolynomial(s32 n, s32 i, xf32 t, xf32 nv[])
{
	xf32 d1 = XF32_ZERO;
	xf32 d2 = XF32_ZERO;
	if( n == 1 )
	{
		if( t >= nv[i] && t < nv[i+1] ) return XF32_ONE;
		return XF32_ZERO;
	}
	xf32 k1 = nv[i+n] - nv[i+1];
	xf32 k2 = nv[i+n-1] - nv[i];
	if( k1 != XF32_ZERO )	d1 = XF32_Mul( XF32_Div(nv[i+n] - t, k1), XF_BSplinePolynomial(n-1, i+1, t, nv) );
	if( k2 != XF32_ZERO )	d2 = XF32_Mul( XF32_Div(t - nv[i]  , k2), XF_BSplinePolynomial(n-1, i  , t, nv) );
	return d1 + d2;
}

}	// end of namespace xf
}	// end of namespace iris

#endif
