//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFComplex.h
 * @brief		fZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFComplex_H_
#define INCG_IRIS_MathXFComplex_H_

//======================================================================
// include
#include "MathXFpu.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexSet(IrisXFComplex* pc0, xf32 re, xf32 im);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexZero(IrisXFComplex* pc0);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexAdd(IrisXFComplex* pc0, const IrisXFComplex* pc1, const IrisXFComplex* pc2);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexSub(IrisXFComplex* pc0, const IrisXFComplex* pc1, const IrisXFComplex* pc2);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexMul(IrisXFComplex* pc0, const IrisXFComplex* pc1, const IrisXFComplex* pc2);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexDiv(IrisXFComplex* pc0, const IrisXFComplex* pc1, const IrisXFComplex* pc2);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexAddReal(IrisXFComplex* pc0, const IrisXFComplex* pc1, xf32 re);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexSubReal(IrisXFComplex* pc0, const IrisXFComplex* pc1, xf32 re);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexMulReal(IrisXFComplex* pc0, const IrisXFComplex* pc1, xf32 re);
IRIS_XFPU_INLINE IrisXFComplex*	XFpuComplexDivReal(IrisXFComplex* pc0, const IrisXFComplex* pc1, xf32 re);

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFComplex.inl"
#endif

#endif
