//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFMatrix22.h
 * @brief		2x2}gbNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFMatrix22_H_
#define INCG_IRIS_MathXFMatrix22_H_

//======================================================================
// include
#include "MathXFpuDef.h"
#include "MathXFVector2.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Unit(IrisXFMtx22* pm0);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Zero(IrisXFMtx22* pm0);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Copy(IrisXFMtx22* pm0, const IrisXFMtx22* pm1);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuMtx22Transform(IrisXFVec2* pv0, const IrisXFMtx22* pm0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Mul(IrisXFMtx22* pm0, const IrisXFMtx22* pm1, const IrisXFMtx22* pm2);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Scale(IrisXFMtx22* pm0, const IrisXFMtx22* pm1, xf32 s);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Transpose(IrisXFMtx22* pm0, const IrisXFMtx22* pm1);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22RotZ(IrisXFMtx22* pm0, const IrisXFMtx22* pm1, xf32 rz);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22RotIdxZ(IrisXFMtx22* pm0, const IrisXFMtx22* pm1, u16 idz);
IRIS_XFPU_INLINE IrisBool		XFpuMtx22IsUnit(const IrisXFMtx22* pm0);
IRIS_XFPU_INLINE xf32			XFpuMtx22Trace(const IrisXFMtx22* pm0);
IRIS_XFPU_INLINE xf32			XFpuMtx22Determinant(const IrisXFMtx22* pm0);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Adjoint(IrisXFMtx22* pm0, const IrisXFMtx22* pm1);
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22TruncatePrecision24(IrisXFMtx22* pm0, const IrisXFMtx22* pm1);

//======================================================================
// inline
STATICINLINE IrisXFMtx22*	XFpuMtx22Identity(IrisXFMtx22* pm0)			{ return XFpuMtx22Unit(pm0); }
STATICINLINE IrisXFMtx22*	XFpuMtx22Null(IrisXFMtx22* pm0)				{ return XFpuMtx22Zero(pm0); }
STATICINLINE IrisXFVec2*	XFpuMtx22Apply(IrisXFVec2* pv0, const IrisXFMtx22* pm0, const IrisXFVec2* pv1)	{ return XFpuMtx22Transform(pv0, pm0, pv1); }
STATICINLINE IrisBool		XFpuMtx22IsIdentity(const IrisXFMtx22* pm0)	{ return XFpuMtx22IsUnit(pm0); }

}	// end of namespace xf
}	// end of namespace iris


#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFMatrix22.inl"
#endif


#endif
