//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFQuaternion.h
 * @brief		NH[^jI֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFQuaternion_H_
#define INCG_IRIS_MathXFQuaternion_H_

//======================================================================
// include
#include "MathXFVector4.h"
#include <string.h>

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionUnit(IrisXFQuaternion* pq0);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionCopy(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionAdd(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1, const IrisXFQuaternion* pq2);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionSub(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1, const IrisXFQuaternion* pq2);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionMul(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1, const IrisXFQuaternion* pq2);
IRIS_XFPU_INLINE xf32				XFpuQuaternionInnerProduct(const IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionConj(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1);
IRIS_XFPU_INLINE IrisXFVec4*		XFpuQuaternionTransform(IrisXFVec4* pv0, const IrisXFQuaternion* pq0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionSlerp(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1, const IrisXFQuaternion* pq2, xf32 t);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionSquad(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1, const IrisXFQuaternion* pq2
											, const IrisXFQuaternion* pq3, const IrisXFQuaternion* pq4, xf32 t);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionNormalize(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionInverse(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionLn(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionExp(IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1);
IRIS_XFPU_INLINE IrisXFMtx44*		XFpuQuaternionToMatrix(IrisXFMtx44* pm0, const IrisXFQuaternion* pq0);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionFromMatrix(IrisXFQuaternion* pq0, const IrisXFMtx44* pm0);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionFromRotZYX(IrisXFQuaternion* pq0, const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionFromRotXYZ(IrisXFQuaternion* pq0, const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionFromRotYXZ(IrisXFQuaternion* pq0, const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisXFQuaternion*	XFpuQuaternionFromRotate(IrisXFQuaternion* pq0, xf32 angle, const IrisXFVec4* pvAxis);
IRIS_XFPU_INLINE IrisXFVec4*		XFpuQuaternionToRotZYX(IrisXFVec4* pv0, const IrisXFQuaternion* pq0);
IRIS_XFPU_INLINE IrisXFVec4*		XFpuQuaternionToRotXYZ(IrisXFVec4* pv0, const IrisXFQuaternion* pq0);
IRIS_XFPU_INLINE IrisXFVec4*		XFpuQuaternionToRotYXZ(IrisXFVec4* pv0, const IrisXFQuaternion* pq0);

//======================================================================
// inline
STATICINLINE IrisXFQuaternion*	XFpuQuaternionIdentity(IrisXFQuaternion* pq0)	{ return XFpuQuaternionUnit(pq0); }
STATICINLINE IrisXFVec4*		XFpuQuaternionApply(IrisXFVec4* pv0, const IrisXFQuaternion* pq0, const IrisXFVec4* pv1)	{ return XFpuQuaternionTransform(pv0, pq0, pv1); }
STATICINLINE xf32				XFpuQuaternionDot(const IrisXFQuaternion* pq0, const IrisXFQuaternion* pq1)				{ return XFpuQuaternionInnerProduct(pq0, pq1); }

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFQuaternion.inl"
#endif

#endif
