//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFVector2.h
 * @brief		2DxNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFVector2_H_
#define INCG_IRIS_MathXFVector2_H_

//======================================================================
// include
#include "MathXFpuDef.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Set(IrisXFVec2* pv0, xf32 x, xf32 y);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Copy(IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2PositiveZero(IrisXFVec2* pv0);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2NegativeZero(IrisXFVec2* pv0);
IRIS_XFPU_INLINE IrisIVec2*		XFpuVec2Ceil(IrisIVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisIVec2*		XFpuVec2Trunc(IrisIVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisIVec2*		XFpuVec2Round(IrisIVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisIVec2*		XFpuVec2Floor(IrisIVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2FromIVec2(IrisXFVec2* pv0, const IrisIVec2* pv1);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Add(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Sub(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Mul(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Div(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Neg(IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Abs(IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Lerp(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2, xf32 t);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Scale(IrisXFVec2* pv0, const IrisXFVec2* pv1, xf32 s);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2ScaleAdd(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2, xf32 s);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Hermite(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pt1
									  , const IrisXFVec2* pv2, const IrisXFVec2* pt2, xf32 t);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Bezier(IrisXFVec2* pv0, s32 n, const IrisXFVec2* pva, xf32 t);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Clamp(IrisXFVec2* pv0, const IrisXFVec2* pv1, xf32 min, xf32 max);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Max(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Min(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2);
IRIS_XFPU_INLINE xf32			XFpuVec2InnerProduct(const IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE xf32			XFpuVec2OuterProduct(const IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE xf32			XFpuVec2Funnel(const IrisXFVec2* pv0);
IRIS_XFPU_INLINE xf32			XFpuVec2Average(const IrisXFVec2* pv0);
IRIS_XFPU_INLINE IrisBool		XFpuVec2IsEqual(const IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisBool		XFpuVec2IsZero(const IrisXFVec2* pv0);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2SignFloat(IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisIVec2*		XFpuVec2SignInt(IrisIVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Normalize(IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE xf32			XFpuVec2Length(const IrisXFVec2* pv0);
IRIS_XFPU_INLINE xf32			XFpuVec2Distance(const IrisXFVec2* pv0, const IrisXFVec2* pv1);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2FaceForward(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2, const IrisXFVec2* pv3);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Reflect(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2Refract(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2, xf32 eta);
IRIS_XFPU_INLINE IrisXFVec2*	XFpuVec2TruncatePrecision24(IrisXFVec2* pv0, const IrisXFVec2* pv1);

//======================================================================
// function
STATICINLINE IrisXFVec2*	XFpuVec2Null(IrisXFVec2* pv0)	{ return XFpuVec2PositiveZero(pv0); }
STATICINLINE IrisXFVec2*	XFpuVec2Zero(IrisXFVec2* pv0)	{ return XFpuVec2PositiveZero(pv0); }
STATICINLINE xf32			XFpuVec2Dot(const IrisXFVec2* pv0, const IrisXFVec2* pv1)	{ return XFpuVec2InnerProduct(pv0, pv1); }
STATICINLINE xf32			XFpuVec2Cross(const IrisXFVec2* pv0, const IrisXFVec2* pv1)	{ return XFpuVec2OuterProduct(pv0, pv1); }
STATICINLINE IrisXFVec2*	XFpuVec2Subtract(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2)	{ return XFpuVec2Sub(pv0, pv1, pv2); }
STATICINLINE IrisXFVec2*	XFpuVec2Multiply(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2)	{ return XFpuVec2Mul(pv0, pv1, pv2); }
STATICINLINE IrisXFVec2*	XFpuVec2Divide(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2)	{ return XFpuVec2Div(pv0, pv1, pv2); }
STATICINLINE IrisXFVec2*	XFpuVec2Inter(IrisXFVec2* pv0, const IrisXFVec2* pv1, const IrisXFVec2* pv2, xf32 t)	{ return XFpuVec2Lerp(pv0, pv1, pv2, t); }

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFVector2.inl"
#endif

#endif
