//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFVector3.h
 * @brief		3DxNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFVector3_H_
#define INCG_IRIS_MathXFVector3_H_

//======================================================================
// include
#include "MathXFpuDef.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Set(IrisXFVec3* pv0, xf32 x, xf32 y, xf32 z);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Copy(IrisXFVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3PositiveZero(IrisXFVec3* pv0);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3NegativeZero(IrisXFVec3* pv0);
IRIS_XFPU_INLINE IrisIVec3*		XFpuVec3Ceil(IrisIVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisIVec3*		XFpuVec3Trunc(IrisIVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisIVec3*		XFpuVec3Round(IrisIVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisIVec3*		XFpuVec3Floor(IrisIVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3FromIVec3(IrisXFVec3* pv0, const IrisIVec3* pv1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Add(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Sub(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Mul(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Div(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Neg(IrisXFVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Abs(IrisXFVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Lerp(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2, xf32 t);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Scale(IrisXFVec3* pv0, const IrisXFVec3* pv1, xf32 s);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3ScaleAdd(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2, xf32 s);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Hermite(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pt1
										, const IrisXFVec3* pv2, const IrisXFVec3* pt2, xf32 t);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Bezier(IrisXFVec3* pv0, s32 n, const IrisXFVec3* pva, xf32 t);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Clamp(IrisXFVec3* pv0, const IrisXFVec3* pv1, xf32 min, xf32 max);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Max(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Min(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
IRIS_XFPU_INLINE xf32			XFpuVec3InnerProduct(const IrisXFVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3OuterProduct(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
IRIS_XFPU_INLINE xf32			XFpuVec3Funnel(const IrisXFVec3* pv0);
IRIS_XFPU_INLINE xf32			XFpuVec3Average(const IrisXFVec3* pv0);
IRIS_XFPU_INLINE IrisBool		XFpuVec3IsEqual(const IrisXFVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisBool		XFpuVec3IsZero(const IrisXFVec3* pv0);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3SignFloat(IrisXFVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisIVec3*		XFpuVec3SignInt(IrisIVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Normalize(IrisXFVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE xf32			XFpuVec3Length(const IrisXFVec3* pv0);
IRIS_XFPU_INLINE xf32			XFpuVec3Distance(const IrisXFVec3* pv0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3FaceForward(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2, const IrisXFVec3* pv3);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Reflect(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3Refract(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2, xf32 eta);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuVec3TruncatePrecision24(IrisXFVec3* pv0, const IrisXFVec3* pv1);

//======================================================================
// inline function
STATICINLINE IrisXFVec3*	XFpuVec3Null(IrisXFVec3* pv0)	{ return XFpuVec3PositiveZero(pv0); }
STATICINLINE IrisXFVec3*	XFpuVec3Zero(IrisXFVec3* pv0)	{ return XFpuVec3PositiveZero(pv0); }
STATICINLINE xf32			XFpuVec3Dot(const IrisXFVec3* pv0, const IrisXFVec3* pv1)						{ return XFpuVec3InnerProduct(pv0, pv1); }
STATICINLINE IrisXFVec3*	XFpuVec3Cross(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2)		{ return XFpuVec3OuterProduct(pv0, pv1, pv2); }
STATICINLINE IrisXFVec3*	XFpuVec3Subtract(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2)	{ return XFpuVec3Sub(pv0, pv1, pv2); }
STATICINLINE IrisXFVec3*	XFpuVec3Multiply(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2)	{ return XFpuVec3Mul(pv0, pv1, pv2); }
STATICINLINE IrisXFVec3*	XFpuVec3Divide(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2)	{ return XFpuVec3Div(pv0, pv1, pv2); }
STATICINLINE IrisXFVec3*	XFpuVec3Inter(IrisXFVec3* pv0, const IrisXFVec3* pv1, const IrisXFVec3* pv2, xf32 t)	{ return XFpuVec3Lerp(pv0, pv1, pv2, t); }

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFVector3.inl"
#endif

#endif
