//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFpu.h
 * @brief		lZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFpu_H_
#define INCG_IRIS_MathXFpu_H_

//======================================================================
// include
#include "MathXFpuDef.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE xf32		XFpuAbs(xf32 fs);
IRIS_XFPU_INLINE s32		XFpuCeil(xf32 fs);
IRIS_XFPU_INLINE s32		XFpuFloor(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuMax(xf32 a, xf32 b);
IRIS_XFPU_INLINE xf32		XFpuMin(xf32 a, xf32 b);
IRIS_XFPU_INLINE xf32		XFpuNeg(xf32 fs);
IRIS_XFPU_INLINE s32		XFpuRound(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuRsqrt(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuSqrt(xf32 fs);
IRIS_XFPU_INLINE s32		XFpuTrunc(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuFmod(xf32 fs, xf32 fd);
IRIS_XFPU_INLINE xf32		XFpuFrac(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuReinterpretFloat(u32 ui);
IRIS_XFPU_INLINE u32		XFpuReinterpretUint(xf32 fs);
IRIS_XFPU_INLINE IrisBool	XFpuIsEqual(xf32 fs1, xf32 fs2);
IRIS_XFPU_INLINE xf32		XFpuSignFloat(xf32 fs);
IRIS_XFPU_INLINE s32		XFpuSignInt(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuPositiveZero(void);
IRIS_XFPU_INLINE xf32		XFpuNegativeZero(void);
IRIS_XFPU_INLINE IrisBool	XFpuIsZero(xf32 fs);
IRIS_XFPU_INLINE IrisBool	XFpuIsPositiveZero(xf32 fs);
IRIS_XFPU_INLINE IrisBool	XFpuIsNegativeZero(xf32 fs);
IRIS_XFPU_INLINE s32		XFpuIsDenormal(xf32 fs);
IRIS_XFPU_INLINE s32		XFpuIsZeroOrDenormal(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuPositiveInf(void);
IRIS_XFPU_INLINE xf32		XFpuNegativeInf(void);
IRIS_XFPU_INLINE s32		XFpuIsInf(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuPositiveNaN(void);
IRIS_XFPU_INLINE xf32		XFpuNegativeNaN(void);
IRIS_XFPU_INLINE xf32		XFpuPositiveQNaN(void);
IRIS_XFPU_INLINE xf32		XFpuNegativeQNaN(void);
IRIS_XFPU_INLINE xf32		XFpuPositiveSNaN(u32 signal);
IRIS_XFPU_INLINE xf32		XFpuPositiveSNaNF(xf32 signal);
IRIS_XFPU_INLINE xf32		XFpuNegativeSNaN(u32 signal);
IRIS_XFPU_INLINE xf32		XFpuNegativeSNaNF(xf32 signal);
IRIS_XFPU_INLINE s32		XFpuIsNaN(xf32 fs);
IRIS_XFPU_INLINE s32		XFpuIsInfOrNaN(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuNormalizePhase(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuSin(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuCos(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuAtan(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuAsin(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuAcos(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuLog(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuLog2(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuLog10(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuExp(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuExp2(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuExp10(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuPow(xf32 x, xf32 y);
IRIS_XFPU_INLINE xf64		XFpuXF32ToXF64(xf32 fs);
IRIS_XFPU_INLINE xf32		XFpuXF64ToXF32(xf64 fs);

//======================================================================
// inline
STATICINLINE xf32	XFpuZero(void)			{ return XFpuPositiveZero(); }
STATICINLINE xf32	XFpuInf(void)			{ return XFpuPositiveInf(); }
STATICINLINE xf32	XFpuNaN(void)			{ return XFpuPositiveNaN(); }
STATICINLINE xf32	XFpuQNaN(void)			{ return XFpuPositiveQNaN(); }
STATICINLINE xf32	XFpuSNaN(u32 signal)	{ return XFpuPositiveSNaN(signal); }

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFpu.inl"
#endif

#endif
