//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFpuInline.h
 * @brief		inline g֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFpuInline_H_
#define INCG_IRIS_MathXFpuInline_H_

//======================================================================
// include
#include "MathXFVector2.h"
#include "MathXFVector3.h"
#include "MathXFVector4.h"

namespace iris {
namespace xf
{

//======================================================================
// decalre
STATICINLINE	xf32		InlXFpu_Vec2PointToLineInnerProduct(const IrisXFVec2* ppnt, const IrisXFVec2* pv0, const IrisXFVec2* pv1);
STATICINLINE	xf32		InlXFpu_Vec3PointToLineInnerProduct(const IrisXFVec3* ppnt, const IrisXFVec3* pv0, const IrisXFVec3* pv1);
STATICINLINE	xf32		InlXFpu_Vec4PointToLineInnerProduct(const IrisXFVec4* ppnt, const IrisXFVec4* pv0, const IrisXFVec4* pv1);
STATICINLINE	xf32		InlXFpu_Vec2PointToLineOuterProduct(const IrisXFVec2* ppnt, const IrisXFVec2* pv0, const IrisXFVec2* pv1);
STATICINLINE	IrisXFVec3*	InlXFpu_Vec3PointToLineOuterProduct(IrisXFVec3* pv0, const IrisXFVec3* ppnt, const IrisXFVec3* pv1, const IrisXFVec3* pv2);
STATICINLINE	IrisXFVec4*	InlXFpu_Vec4PointToLineOuterProduct(IrisXFVec4* pv0, const IrisXFVec4* ppnt, const IrisXFVec4* pv1, const IrisXFVec4* pv2);


//======================================================================
// inline function
/**
 * @brief	_PƐA̓
 * @note	_Ǝn_ȂBƐA̓
 * @param [in]	ppnt	= _
 * @param [in]	pv0		= n_
 * @param [in]	pv1		= I_
 * @return	
*/
STATICINLINE	xf32		InlXFpu_Vec2PointToLineInnerProduct(const IrisXFVec2* ppnt, const IrisXFVec2* pv0, const IrisXFVec2* pv1)
{
	XFPU_NULLASSERT( ppnt );
	XFPU_NULLASSERT( pv0 );
	XFPU_NULLASSERT( pv1 );
	IrisXFVec2 v0, v1;
	XFpuVec2Sub(&v0, ppnt, pv0);
	XFpuVec2Sub(&v1, pv1 , pv0);
	return XFpuVec2InnerProduct(&v0, &v1);
}

/**
 * @brief	_PƐA̓
 * @note	_Ǝn_ȂBƐA̓
 * @param [in]	ppnt	= _
 * @param [in]	pv0		= n_
 * @param [in]	pv1		= I_
 * @return	
*/
STATICINLINE	xf32		InlXFpu_Vec3PointToLineInnerProduct(const IrisXFVec3* ppnt, const IrisXFVec3* pv0, const IrisXFVec3* pv1)
{
	XFPU_NULLASSERT( ppnt );
	XFPU_NULLASSERT( pv0 );
	XFPU_NULLASSERT( pv1 );
	IrisXFVec3 v0, v1;
	XFpuVec3Sub(&v0, ppnt, pv0);
	XFpuVec3Sub(&v1, pv1 , pv0);
	return XFpuVec3InnerProduct(&v0, &v1);
}

/**
 * @brief	_PƐA̓
 * @note	_Ǝn_ȂBƐA̓
 * @param [in]	ppnt	= _
 * @param [in]	pv0		= n_
 * @param [in]	pv1		= I_
 * @return	
*/
STATICINLINE	xf32		InlXFpu_Vec4PointToLineInnerProduct(const IrisXFVec4* ppnt, const IrisXFVec4* pv0, const IrisXFVec4* pv1)
{
	XFPU_NULLASSERT( ppnt );
	XFPU_NULLASSERT( pv0 );
	XFPU_NULLASSERT( pv1 );
	IrisXFVec4 v0, v1;
	XFpuVec4Sub(&v0, ppnt, pv0);
	XFpuVec4Sub(&v1, pv1 , pv0);
	return XFpuVec4InnerProduct(&v0, &v1);
}

/**
 * @brief	_PƐÅO
 * @note	_Ǝn_ȂBƐÅO
 * @param [in]	ppnt	= _
 * @param [in]	pv0		= n_
 * @param [in]	pv1		= I_
 * @return	O
*/
STATICINLINE	xf32		InlXFpu_Vec2PointToLineOuterProduct(const IrisXFVec2* ppnt, const IrisXFVec2* pv0, const IrisXFVec2* pv1)
{
	XFPU_NULLASSERT( ppnt );
	XFPU_NULLASSERT( pv0 );
	XFPU_NULLASSERT( pv1 );
	IrisXFVec2 v0, v1;
	XFpuVec2Sub(&v0, ppnt, pv0);
	XFpuVec2Sub(&v1, pv1 , pv0);
	return XFpuVec2OuterProduct(&v0, &v1);
}

/**
 * @brief	_PƐÅO
 * @note	_Ǝn_ȂBƐÅO
 * @param [out]	pv0		= o̓xNg
 * @param [in]	ppnt	= _
 * @param [in]	pv1		= n_
 * @param [in]	pv2		= I_
 * @return	o̓xNg
*/
STATICINLINE	IrisXFVec3*	InlXFpu_Vec3PointToLineOuterProduct(IrisXFVec3* pv0, const IrisXFVec3* ppnt, const IrisXFVec3* pv1, const IrisXFVec3* pv2)
{
	XFPU_NULLASSERT( ppnt );
	XFPU_NULLASSERT( pv0 );
	XFPU_NULLASSERT( pv1 );
	XFPU_NULLASSERT( pv2 );
	IrisXFVec3 v0, v1;
	XFpuVec3Sub(&v0, ppnt, pv1);
	XFpuVec3Sub(&v1, pv2 , pv1);
	return XFpuVec3OuterProduct(pv0, &v0, &v1);
}

/**
 * @brief	_PƐÅO
 * @note	_Ǝn_ȂBƐÅO
 * @param [out]	pv0		= o̓xNg
 * @param [in]	ppnt	= _
 * @param [in]	pv1		= n_
 * @param [in]	pv2		= I_
 * @return	o̓xNg
*/
STATICINLINE	IrisXFVec4*	InlXFpu_Vec3PointToLineOuterProduct(IrisXFVec4* pv0, const IrisXFVec4* ppnt, const IrisXFVec4* pv1, const IrisXFVec4* pv2)
{
	XFPU_NULLASSERT( ppnt );
	XFPU_NULLASSERT( pv0 );
	XFPU_NULLASSERT( pv1 );
	XFPU_NULLASSERT( pv2 );
	IrisXFVec4 v0, v1;
	XFpuVec4SubXYZ(&v0, ppnt, pv1);
	XFpuVec4SubXYZ(&v1, pv2 , pv1);
	return XFpuVec4OuterProductXYZ(pv0, &v0, &v1);
}

}	// end of namespace xf
}	// end of namespace iris

#endif
