//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFMatrix22.inl
 * @brief		2x2}gbNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFMatrix22_inl_
#define INCG_IRIS_MathXFMatrix22_inl_

namespace iris {
namespace xf
{

//======================================================================
// function
/**
 * @brief	Pʃ}gbNX̐
 * @param [out]	pm0	= o̓}gbNX
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Unit(IrisXFMtx22* pm0)
{
	XFPU_NULLASSERT( pm0 );
	pm0->x.x = pm0->y.y = XF32_ONE;
	pm0->x.y = pm0->y.x = XF32_ZERO;
	return pm0;
}

/**
 * @brief	[s̐
 * @param [out]	pm0	= o̓}gbNX
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Zero(IrisXFMtx22* pm0)
{
	XFPU_NULLASSERT( pm0 );
	XFpuVec2Zero(&pm0->x);
	XFpuVec2Zero(&pm0->y);
	return pm0;
}

/**
 * @brief	}gbNX̃Rs[
 * @param [out]	pm0	= o̓}gbNX
 * @param [in]	pm1	= ̓}gbNX
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Copy(IrisXFMtx22* pm0, const IrisXFMtx22* pm1)
{
	XFPU_NULLASSERT( pm0 );
	XFPU_NULLASSERT( pm1 );
#if 1
	pm0->_00 = pm1->_00;
	pm0->_01 = pm1->_01;
	pm0->_10 = pm1->_10;
	pm0->_11 = pm1->_11;
#else
	XFpuVec2Copy(&pm0->x, &pm1->x);
	XFpuVec2Copy(&pm0->y, &pm1->y);
#endif
	return pm0;
}

/**
 * @brief	xNgɃ}gbNXZ
 * @param [out]	pv0	= o̓xNg
 * @param [in]	pm0	= ̓}gbNX
 * @param [in]	pv1	= ̓xNg
 * @return	o̓xNg
*/
IRIS_XFPU_INLINE IrisXFVec2*	XFpuMtx22Transform(IrisXFVec2* pv0, const IrisXFMtx22* pm0, const IrisXFVec2* pv1)
{
	XFPU_NULLASSERT( pm0 );
	XFPU_NULLASSERT( pv0 );
	XFPU_NULLASSERT( pv1 );
	IRIS_ASSERT( pv0 != pv1 );	// TODO : AhXɖΉ
	pv0->x = XF32_Mul(pm0->x.x, pv1->x) + XF32_Mul(pm0->y.x, pv1->y);
	pv0->y = XF32_Mul(pm0->x.y, pv1->x) + XF32_Mul(pm0->y.y, pv1->y);
	return pv0;
}

/**
 * @brief	Q̃}gbNX̐
 * @param [out]	pm0	= o̓}gbNX
 * @param [in]	pm1	= ̓}gbNX
 * @param [in]	pm2	= ̓}gbNX
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Mul(IrisXFMtx22* pm0, const IrisXFMtx22* pm1, const IrisXFMtx22* pm2)
{
	XFPU_NULLASSERT( pm0 );
	XFPU_NULLASSERT( pm1 );
	XFPU_NULLASSERT( pm2 );
	IRIS_ASSERT( pm0 != pm1 );
	IRIS_ASSERT( pm0 != pm2 );
	pm0->x.x = XF32_Mul(pm1->x.x, pm2->x.x) + XF32_Mul(pm1->y.x, pm2->x.y);
	pm0->x.y = XF32_Mul(pm1->x.y, pm2->x.x) + XF32_Mul(pm1->y.y, pm2->x.y);
	pm0->y.x = XF32_Mul(pm1->x.x, pm2->y.x) + XF32_Mul(pm1->y.x, pm2->y.y);
	pm0->y.y = XF32_Mul(pm1->x.y, pm2->y.x) + XF32_Mul(pm1->y.y, pm2->y.y);
	return pm0;
}

/**
 * @brief	}gbNX̃XP[O
 * @param [out]	pm0	= o̓}gbNX
 * @param [in]	pm1	= ̓}gbNX
 * @param [in]	s	= XJ[l
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Scale(IrisXFMtx22* pm0, const IrisXFMtx22* pm1, xf32 s)
{
	XFPU_NULLASSERT( pm0 );
	XFPU_NULLASSERT( pm1 );
	XFpuVec2Scale(&pm0->x, &pm1->x, s);
	XFpuVec2Scale(&pm0->y, &pm1->y, s);
	return pm0;
}

/**
 * @brief	}gbNX̓]us߂
 * @param [out]	pm0	= o̓}gbNX
 * @param [in]	pm1	= ̓}gbNX
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Transpose(IrisXFMtx22* pm0, const IrisXFMtx22* pm1)
{
	XFPU_NULLASSERT( pm0 );
	XFPU_NULLASSERT( pm1 );
	pm0->x.x = pm1->x.x;
	xf32 f = pm1->x.y;
	pm0->x.y = pm1->y.x;
	pm0->y.x = f;
	pm0->y.y = pm1->y.y;
	return pm0;
}

/**
 * @brief	}gbNXZ]
 * @param [out]	pm0	= o̓}gbNX
 * @param [in]	pm1	= ̓}gbNX
 * @param [in]	rz	= Z]ʁiWAj
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22RotZ(IrisXFMtx22* pm0, const IrisXFMtx22* pm1, xf32 rz)
{
	XFPU_NULLASSERT( pm0 );
	xf32 c = XF32_Cos(rz);
	xf32 s = XF32_Sin(rz);
	if( pm1 == nullptr ) 
	{
		pm0->x.x = +c;
		pm0->x.y = +s;
		pm0->y.x = -s;
		pm0->y.y = +c;
	}
	else
	{
		IrisXFMtx22 m;
		m.x.x = +c;
		m.x.y = +s;
		m.y.x = -s;
		m.y.y = +c;
		XFpuMtx22Mul(pm0, &m, pm1);
	}
	return pm0;
}

/**
 * @brief	}gbNXZ]
 * @param [out]	pm0	= o̓}gbNX
 * @param [in]	pm1	= ̓}gbNX
 * @param [in]	idz	= Z]ʁiCfbNXj
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22RotIdxZ(IrisXFMtx22* pm0, const IrisXFMtx22* pm1, u16 idz)
{
	XFPU_NULLASSERT( pm0 );
	xf32 c = XF32_CosIdx(idz);
	xf32 s = XF32_SinIdx(idz);
	if( pm1 == nullptr ) 
	{
		pm0->x.x = +c;
		pm0->x.y = +s;
		pm0->y.x = -s;
		pm0->y.y = +c;
	}
	else
	{
		IrisXFMtx22 m;
		m.x.x = +c;
		m.x.y = +s;
		m.y.x = -s;
		m.y.y = +c;
		XFpuMtx22Mul(pm0, &m, pm1);
	}
	return pm0;
}

/**
 * @brief	PʍsɂȂĂ邩ǂ
 * @param [in]	pm0	= ̓}gbNX
 * @return	^Ul
*/
IRIS_XFPU_INLINE IrisBool		XFpuMtx22IsUnit(const IrisXFMtx22* pm0)
{
	XFPU_NULLASSERT( pm0 );
	const IrisMtx22* m = (const IrisMtx22*)(pm0);
	if( m->im.x.x != 0x3F800000 || m->im.y.y != 0x3F800000 )
		return IRIS_FALSE;
	if( (m->im.x.y | m->im.y.x) != 0 )
		return IRIS_FALSE;
	return IRIS_TRUE;
}

/**
 * @brief	}gbNX̃g[XԂ
 * @param [in]	pm0	= ̓}gbNX
 * @return	}gbNX̃g[X
*/
IRIS_XFPU_INLINE xf32			XFpuMtx22Trace(const IrisXFMtx22* pm0)
{
	XFPU_NULLASSERT( pm0 );
	return (pm0->x.x + pm0->y.y);
}

/**
 * @brief	s񎮂Ԃ
 * @param [in]	pm0	= ̓}gbNX
 * @return	s
*/
IRIS_XFPU_INLINE xf32			XFpuMtx22Determinant(const IrisXFMtx22* pm0)
{
	XFPU_NULLASSERT( pm0 );
	return (XF32_Mul(pm0->x.x, pm0->y.y) - XF32_Mul(pm0->x.y, pm0->y.x));
}

/**
 * @brief	]qsԂ
 * @param [out]	pm0	= o̓}gbNX
 * @param [in]	pm1	= ̓}gbNX
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22Adjoint(IrisXFMtx22* pm0, const IrisXFMtx22* pm1)
{
	XFPU_NULLASSERT( pm0 );
	XFPU_NULLASSERT( pm1 );
	pm0->x.x =  pm1->x.x;
	pm0->x.y = -pm1->x.y;
	pm0->y.x = -pm1->y.x;
	pm0->y.y =  pm1->y.y;
	return pm0;
}

/**
 * @brief	8rbg̐x؂̂
 * @param [out]	pm0	= o̓}gbNX
 * @param [in]	pm1	= ̓}gbNX
 * @return	o̓}gbNX
*/
IRIS_XFPU_INLINE IrisXFMtx22*	XFpuMtx22TruncatePrecision24(IrisXFMtx22* pm0, const IrisXFMtx22* pm1)
{
	XFPU_NULLASSERT( pm0 );
	XFPU_NULLASSERT( pm1 );
	XFpuVec2TruncatePrecision24(&pm0->x, &pm1->x);
	XFpuVec2TruncatePrecision24(&pm0->y, &pm1->y);
	return pm0;
}


}	// end of namespace xf
}	// end of namespace iris

#endif
