//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFScalar.inl
 * @brief		XJ[lZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFScalar_inl_
#define INCG_IRIS_MathXFScalar_inl_

namespace iris {
namespace xf
{

//======================================================================
// function
/**
 * @brief	_̐ΒlԂ
 * @param [in]	fs	= l
 * @return	Βl
*/
IRIS_XFPU_INLINE xf32	XFpuScalarAbs(xf32 fs)
{
	return XF32_Abs(fs);
}

/**
 * @brief	t](A[NRTC)vZ
 * @param [in]	fs	= l
 * @return	t]
*/
IRIS_XFPU_INLINE xf32	XFpuScalarAcos(xf32 fs)
{
	return XF32_Acos(fs);
}

/**
 * @brief	t(A[NTC)vZ
 * @param [in]	fs	= l
 * @return	t
*/
IRIS_XFPU_INLINE xf32	XFpuScalarAsin(xf32 fs)
{
	return XF32_Asin(fs);
}

/**
 * @brief	t(A[N^WFg)vZ
 * @param [in]	fs	= l
 * @return	t
*/
IRIS_XFPU_INLINE xf32	XFpuScalarAtan(xf32 fs)
{
	return XF32_Atan(fs);
}

/**
 * @brief	t(A[N^WFg)vZ
 * @param [in]	y	= yl
 * @param [in]	x	= xl
 * @return	t
*/
IRIS_XFPU_INLINE xf32	XFpuScalarAtan2(xf32 y, xf32 x)
{
	return XF32_Atan2(y, x);
}

/**
 * @brief	XJ[l̐؂グ
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32	XFpuScalarCeil(xf32 fs)
{
	return XF32_Ceil(fs);
}

/**
 * @brief	](RTC)vZ
 * @param [in]	fs	= WAl
 * @return	]
*/
IRIS_XFPU_INLINE xf32	XFpuScalarCos(xf32 fs)
{
	return XF32_Cos(fs);
}

/**
 * @brief	eƂw
 * @param [in]	fs	= l
 * @return	eƂw
*/
IRIS_XFPU_INLINE xf32	XFpuScalarExp(xf32 fs)
{
	return XF32_Exp(fs);
}

/**
 * @brief	XJ[l̐؂̂
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32	XFpuScalarFloor(xf32 fs)
{
	return XF32_Floor(fs);
}

/**
 * @brief	Rΐ
 * @param [in]	fs	= l
 * @return	Rΐ
*/
IRIS_XFPU_INLINE xf32	XFpuScalarLog(xf32 fs)
{
	return XF32_Log(fs);
}

/**
 * @brief	2Ƃΐ
 * @param [in]	fs	= l
 * @return	2Ƃΐ
*/
IRIS_XFPU_INLINE xf32	XFpuScalarLog2(xf32 fs)
{
	return XF32_Log2(fs);
}

/**
 * @brief	pΐ
 * @param [in]	fs	= l
 * @return	pΐ
*/
IRIS_XFPU_INLINE xf32	XFpuScalarLog10(xf32 fs)
{
	return XF32_Log10(fs);
}

/**
 * @brief	XJ[ől
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ől
*/
IRIS_XFPU_INLINE xf32	XFpuScalarMax(xf32 a, xf32 b)
{
	return (a > b) ? a : b;
}

/**
 * @brief	XJ[ŏl
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ŏl
*/
IRIS_XFPU_INLINE xf32	XFpuScalarMin(xf32 a, xf32 b)
{
	return (a < b) ? a : b;
}

/**
 * @brief	w
 * @param [in]	x	= l
 * @param [in]	y	= l
 * @return	w
*/
IRIS_XFPU_INLINE xf32	XFpuScalarPow(xf32 x, xf32 y)
{
	return XF32_Pow(x, y);
}

/**
 * @brief	2Ƃw
 * @param [in]	fs	= l
 * @return	w
*/
IRIS_XFPU_INLINE xf32	XFpuScalarPow2(xf32 fs)
{
	return XF32_Pow2(fs);
}

/**
 * @brief	ߖTۂ(ľܓ)
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32	XFpuScalarRound(xf32 fs)
{
	return XF32_Round(fs);
}

/**
 * @brief	̋t
 * @param [in]	fs	= l
 * @return	̋t
*/
IRIS_XFPU_INLINE xf32	XFpuScalarRsqrt(xf32 fs)
{
	return XF32_Rsqrt(fs);
}

/**
 * @brief	(TC)
 * @param [in]	fs	= WAl
 * @return	
*/
IRIS_XFPU_INLINE xf32	XFpuScalarSin(xf32 fs)
{
	return XF32_Sin(fs);
}

/**
 * @brief	
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32	XFpuScalarSqrt(xf32 fs)
{
	return XF32_Sqrt(fs);
}

/**
 * @brief	(^WFg)
 * @param [in]	fs	= WAl
 * @return	
*/
IRIS_XFPU_INLINE xf32	XFpuScalarTan(xf32 fs)
{
	return XF32_Tan(fs);
}

/**
 * @brief	0ۂ
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32	XFpuScalarTrunc(xf32 fs)
{
	return XF32_Trunc(fs);
}

/**
 * @brief	̉8rbg̐x؂̂
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32	XFpuScalarTruncatePrecision24(xf32 fs)
{
	IrisXFInt v = fs;
	v.iv &= 0xFFFFFF00;
	return v.fv;
}

}	// end of namespace xf
}	// end of namespace iris

#endif
