//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFpu.inl
 * @brief		lZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFpu_inl_
#define INCG_IRIS_MathXFpu_inl_

namespace iris {
namespace xf
{

//======================================================================
// function
/**
 * @brief	_̐ΒlԂ
 * @param [in]	fs	= l
 * @return	Βl
*/
IRIS_XFPU_INLINE xf32		XFpuAbs(xf32 fs)
{
	return XF32_Abs(fs);
}

/**
 * @brief	XJ[l̐؂グ
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE s32		XFpuCeil(xf32 fs)
{
	return XF_XF32_TO_S32( XF32_Ceil(fs) );
}

/**
 * @brief	XJ[l̐؂̂
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE s32		XFpuFloor(xf32 fs)
{
	return XF_XF32_TO_S32( XF32_Floor(fs) );
}

/**
 * @brief	XJ[ől
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ől
*/
IRIS_XFPU_INLINE xf32		XFpuMax(xf32 a, xf32 b)
{
	return (a > b) ? a : b;
}

/**
 * @brief	XJ[ŏl
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ŏl
*/
IRIS_XFPU_INLINE xf32		XFpuMin(xf32 a, xf32 b)
{
	return (a < b) ? a : b;
}

/**
 * @brief	̕Ԃ
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32		XFpuNeg(xf32 fs)
{
	return -fs;
}

/**
 * @brief	ߖTۂ(ľܓ)
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE s32		XFpuRound(xf32 fs)
{
	return XF_XF32_TO_S32( XF32_Round(fs) );
}

/**
 * @brief	̋t
 * @param [in]	fs	= l
 * @return	̋t
*/
IRIS_XFPU_INLINE xf32		XFpuRsqrt(xf32 fs)
{
	return XF32_Rsqrt(fs);
}

/**
 * @brief	
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32		XFpuSqrt(xf32 fs)
{
	return XF32_Sqrt(fs);
}

/**
 * @brief	0ۂ
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE s32		XFpuTrunc(xf32 fs)
{
	return XF_XF32_TO_S32( XF32_Trunc(fs) );
}

/**
 * @brief	̏]
 * @param [in]	fs	= l
 * @param [in]	fd	= l
 * @return	]
*/
IRIS_XFPU_INLINE xf32		XFpuFmod(xf32 fs, xf32 fd)
{
	xf32 v = XF_S32_TO_XF32( XFpuTrunc( XF32_Div(fs, fd) ) );
	return fs - XF32_Mul(v, fd);
}

/**
 * @brief	̎擾
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32		XFpuFrac(xf32 fs)
{
	xf32 v = XF_S32_TO_XF32( XFpuTrunc(fs) );
	return fs - v;
}

/**
 * @brief	^Ƃĕ]
 * @param [in]	ui	= rbgl
 * @return	
*/
IRIS_XFPU_INLINE xf32		XFpuReinterpretFloat(u32 ui)
{
	IrisXFInt xfi; xfi.iv = ui;
	return xfi.fv;
}

/**
 * @brief	̃rbg\Ԃ
 * @param [in]	fs	= l
 * @return	rbg
*/
IRIS_XFPU_INLINE u32		XFpuReinterpretUint(xf32 fs)
{
	IrisXFInt xfi; xfi.fv = fs;
	return xfi.iv;
}

/**
 * @brief	_lł邩Ԃ
 * @param [in]	fs1	= l
 * @param [in]	fs2	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE IrisBool	XFpuIsEqual(xf32 fs1, xf32 fs2)
{
	return fs1 == fs2 ? IRIS_TRUE : IRIS_FALSE;
}

/**
 * @brief	,̕xf32ŕԂ
 * @param [in]	fs	= l
 * @return	,̕
*/
IRIS_XFPU_INLINE xf32		XFpuSignFloat(xf32 fs)
{
	return (fs < XF32_ZERO) ? -XF32_ONE : (fs > XF32_ZERO) ? XF32_ONE : XF32_ZERO;
}

/**
 * @brief	,̕s32ŕԂ
 * @param [in]	fs	= l
 * @return	,̕
*/
IRIS_XFPU_INLINE s32		XFpuSignInt(xf32 fs)
{
	return (fs < XF32_ZERO) ? -1 : (fs > XF32_ZERO) ? 1 : 0;
}

/**
 * @brief	+0擾
 * @return	+0
*/
IRIS_XFPU_INLINE xf32		XFpuPositiveZero(void)
{
	return XF32_ZERO;
}

/**
 * @brief	-0擾
 * @return	-0
*/
IRIS_XFPU_INLINE xf32		XFpuNegativeZero(void)
{
	IrisXFInt xfi; xfi.iv = 0x80000000;
	return xfi.fv;
}

/**
 * @brief	0ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE IrisBool	XFpuIsZero(xf32 fs)
{
	IrisXFInt xfi; xfi.fv = fs;
	return (xfi.iv & 0x7FFFFFFFU) == 0 ? IRIS_TRUE : IRIS_FALSE;
}

/**
 * @brief	+0ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE IrisBool	XFpuIsPositiveZero(xf32 fs)
{
	IrisXFInt xfi; xfi.fv = fs;
	return (xfi.iv == 0) ? IRIS_TRUE : IRIS_FALSE;
}

/**
 * @brief	-0ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE IrisBool	XFpuIsNegativeZero(xf32 fs)
{
	IrisXFInt xfi; xfi.fv = fs;
	return (xfi.iv == 0x80000000) ? IRIS_TRUE : IRIS_FALSE;
}

/**
 * @brief	񐳋Kł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE s32		XFpuIsDenormal(xf32 fs)
{
	s32 ret = 0;
#if (!IRIS_XF_FIXED_FLOAT)
	IrisXFInt xfi; xfi.fv = fs;
	u32 t0 = xfi.iv;
	u32 t1 = t0 & 0x7F800000;
	xfi.iv = t0 | 0x7F800000;
	ret = xfi.iv >> 30 ? +1 : -1;
	t0 = t0 << 9;
	ret = t1 != 0 ? 0 : ret;
	ret = t0 == 0 ? 0 : ret;
#else
	IRIS_UNUSED_VARIABLE(fs);
#endif
	return ret;
}

/**
 * @brief	0܂͔񐳋Kł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE s32		XFpuIsZeroOrDenormal(xf32 fs)
{
	s32 ret = 0;
#if (!IRIS_XF_FIXED_FLOAT)
	IrisXFInt xfi; xfi.fv = fs;
	u32 t0 = xfi.iv;
	u32 t1 = t0 & 0x7F800000;
	xfi.iv = t0 | 0x7F800000;
	ret = xfi.iv >> 30 ? +1 : -1;
	t0 = t0 << 9;
	ret = t1 != 0 ? 0 : ret;
#else
	IRIS_UNUSED_VARIABLE(fs);
#endif
	return ret;
}

/**
 * @brief	+擾
 * @return	+
*/
IRIS_XFPU_INLINE xf32		XFpuPositiveInf(void)
{
	IrisXFInt xfi; xfi.iv = XF32_P_INF_BITS;
	return xfi.fv;
}

/**
 * @brief	-擾
 * @return	-
*/
IRIS_XFPU_INLINE xf32		XFpuNegativeInf(void)
{
	IrisXFInt xfi; xfi.iv = XF32_N_INF_BITS;
	return xfi.fv;
}

/**
 * @brief	ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE s32		XFpuIsInf(xf32 fs)
{
	IrisXFInt xfi; xfi.fv = fs;
	if( xfi.iv == XF32_P_INF_BITS ) return 1;
	if( xfi.iv == XF32_N_INF_BITS )	return -1;
	return 0;
}

/**
 * @brief	+NaN擾
 * @return	+NaN
*/
IRIS_XFPU_INLINE xf32		XFpuPositiveNaN(void)
{
	IrisXFInt xfi; xfi.iv = XF32_P_NAN_BITS;
	return xfi.fv;
}

/**
 * @brief	+NaN擾
 * @return	+NaN
*/
IRIS_XFPU_INLINE xf32		XFpuNegativeNaN(void)
{
	IrisXFInt xfi; xfi.iv = XF32_N_NAN_BITS;
	return xfi.fv;
}

/**
 * @brief	+QNaN擾
 * @return	+QNaN
*/
IRIS_XFPU_INLINE xf32		XFpuPositiveQNaN(void)
{
	IrisXFInt xfi; xfi.iv = XF32_P_QNAN_BITS;
	return xfi.fv;
}

/**
 * @brief	-QNaN擾
 * @return	-QNaN
*/
IRIS_XFPU_INLINE xf32		XFpuNegativeQNaN(void)
{
	IrisXFInt xfi; xfi.iv = XF32_N_QNAN_BITS;
	return xfi.fv;
}

/**
 * @brief	+SNaN擾
 * @param [in]	signal = 
 * @return	+SNaN
*/
IRIS_XFPU_INLINE xf32		XFpuPositiveSNaN(u32 signal)
{
	IrisXFInt xfi; xfi.iv = XF32_P_SNAN_BITS(signal);
	return xfi.fv;
}

/**
 * @brief	+SNaN擾
 * @param [in]	signal = 
 * @return	+SNaN
*/
IRIS_XFPU_INLINE xf32		XFpuPositiveSNaNF(xf32 signal)
{
	IrisXFInt xfi; xfi.fv = signal; xfi.iv = XF32_N_SNAN_BITS(xfi.iv);
	return xfi.fv;
}

/**
 * @brief	-SNaN擾
 * @param [in]	signal = 
 * @return	-SNaN
*/
IRIS_XFPU_INLINE xf32		XFpuNegativeSNaN(u32 signal)
{
	IrisXFInt xfi; xfi.iv = XF32_N_SNAN_BITS(signal);
	return xfi.fv;
}

/**
 * @brief	-SNaN擾
 * @param [in]	signal = 
 * @return	-SNaN
*/
IRIS_XFPU_INLINE xf32		XFpuNegativeSNaNF(xf32 signal)
{
	IrisXFInt xfi; xfi.fv = signal; xfi.iv = XF32_N_SNAN_BITS(xfi.iv);
	return xfi.fv;
}

/**
 * @brief	񐔂ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE s32		XFpuIsNaN(xf32 fs)
{
	IrisXFInt xfi; xfi.fv = fs;
	s32 ret = 0x807FFFFF;
	u32 t0 = xfi.iv;
	u32 t1 = xfi.iv << 1;
	ret = (s32)(ret & t0);
	t1 >>= 24;
	t0 <<= 9;
	t1 = (t1<0xFF);
	ret = (t0==0) ? 0 : ret;
	ret = (t1!=0) ? 0 : ret;
	return ret;
}

/**
 * @brief	or񐔂ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
IRIS_XFPU_INLINE s32		XFpuIsInfOrNaN(xf32 fs)
{
	IrisXFInt xfi; xfi.fv = fs;
	s32 ret = (s32)xfi.iv;
	u32 t0 = xfi.iv << 1;
	ret >>= 30;
	t0 >>= 24;
	ret |= 0x00000001;
	t0 = (t0<0xFF);
	ret = (t0!=0) ? 0 : ret;
	return ret;
}

/**
 * @brief	ʑ-΁`΂ɐK
 * @param [in]	fs	= l
 * @return	
*/
IRIS_XFPU_INLINE xf32		XFpuNormalizePhase(xf32 fs)
{
	xf32 fd = XF32_Div(fs, XF32_2PI);
	s32  f0 = XF_XF32_TO_S32( fd + XF32_HALF );
	fd = XF_S32_TO_XF32( f0 );
	fd = XF32_Mul(fd, XF32_2PI);
	fd = fs - fd;
	return fd;
}

/**
 * @brief	(TC)
 * @param [in]	fs	= WAl
 * @return	
*/
IRIS_XFPU_INLINE xf32		XFpuSin(xf32 fs)
{
	return XF32_Sin(fs);
}

/**
 * @brief	](RTC)vZ
 * @param [in]	fs	= WAl
 * @return	]
*/
IRIS_XFPU_INLINE xf32		XFpuCos(xf32 fs)
{
	return XF32_Cos(fs);
}

/**
 * @brief	t(A[N^WFg)vZ
 * @param [in]	fs	= l
 * @return	t
*/
IRIS_XFPU_INLINE xf32		XFpuAtan(xf32 fs)
{
	return XF32_Atan(fs);
}

/**
 * @brief	t(A[NTC)vZ
 * @param [in]	fs	= l
 * @return	t
*/
IRIS_XFPU_INLINE xf32		XFpuAsin(xf32 fs)
{
	return XF32_Asin(fs);
}

/**
 * @brief	t](A[NRTC)vZ
 * @param [in]	fs	= l
 * @return	t]
*/
IRIS_XFPU_INLINE xf32		XFpuAcos(xf32 fs)
{
	return XF32_Acos(fs);
}

/**
 * @brief	Rΐ
 * @param [in]	fs	= l
 * @return	Rΐ
*/
IRIS_XFPU_INLINE xf32		XFpuLog(xf32 fs)
{
	return XF32_Log(fs);
}

/**
 * @brief	2Ƃΐ
 * @param [in]	fs	= l
 * @return	2Ƃΐ
*/
IRIS_XFPU_INLINE xf32		XFpuLog2(xf32 fs)
{
	return XF32_Log2(fs);
}

/**
 * @brief	pΐ
 * @param [in]	fs	= l
 * @return	pΐ
*/
IRIS_XFPU_INLINE xf32		XFpuLog10(xf32 fs)
{
	return XF32_Log10(fs);
}

/**
 * @brief	eƂw
 * @param [in]	fs	= l
 * @return	eƂw
*/
IRIS_XFPU_INLINE xf32		XFpuExp(xf32 fs)
{
	return XF32_Exp(fs);
}

/**
 * @brief	2Ƃw
 * @param [in]	fs	= l
 * @return	eƂw
*/
IRIS_XFPU_INLINE xf32		XFpuExp2(xf32 fs)
{
	return XF32_Pow(XF32_2, fs);
}

/**
 * @brief	10Ƃw
 * @param [in]	fs	= l
 * @return	eƂw
*/
IRIS_XFPU_INLINE xf32		XFpuExp10(xf32 fs)
{
	return XF32_Pow(XF32_10, fs);
}

/**
 * @brief	w
 * @param [in]	x	= l
 * @param [in]	y	= l
 * @return	w
*/
IRIS_XFPU_INLINE xf32		XFpuPow(xf32 x, xf32 y)
{
	return XF32_Pow(x, y);
}

/**
 * @brief	xf32  xf64ɕϊ
 * @param [in]	fs	= l
 * @return	xf64
*/
IRIS_XFPU_INLINE xf64		XFpuXF32ToXF64(xf32 fs)
{
	return (xf64)fs;
}

/**
 * @brief	xf64  xf32ɕϊ
 * @param [in]	fs	= l
 * @return	xf32
*/
IRIS_XFPU_INLINE xf32		XFpuXF64ToXF32(xf64 fs)
{
	return (xf32)fs;
}

}	// end of namespace xf
}	// end of namespace iris

#endif
