//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		main.cpp
 * @brief		main t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_main_CPP_

//======================================================================
// include
#include "iris_main.h"
#include "win/resource/WXVersionInfo.h"
#include "win/os/WXOSVersion.h"
#include "win/shell/WXCSIDL.h"
#include "win/exp/registry/WXInstallRegistry.h"
#include "fnd/io/FndFile.h"
#include "win/shell/WXShellPath.h"
#include "fnd/container/FndRegexOp.h"
#include "iris_using.h"

#include <tchar.h>
#include <shlwapi.h>

//======================================================================
// link
#pragma comment (lib, "shlwapi.lib")

//======================================================================
// define
#define COMMENT "\
//======================================================================\n\
//-----------------------------------------------------------------------\n\
/**\n\
 * @file		%s.%s\n\
 * @brief		prefix t@C\n\
 *\n\
 * @author		%s\n\
 * @version		%s\n\
*/\n\
//-----------------------------------------------------------------------\n\
//======================================================================\n\
#ifndef _FILE_%s_%s_\n\
#define _FILE_%s_%s_\n\
\n\
"
#define COMMENT_ARG(name, ext, exe, ver)	name, ext, exe, ver, name, ext, name, ext

#define END "\
\n\
#endif\n\
"

#define WINNT "\
#ifndef _WIN32_WINNT\n\
#define _WIN32_WINNT	0x%.4x\n\
#endif\n\
\n\
"

#define DEFINE(def)	""\
"#ifndef " #def "\n"\
"#  define " #def "\n"\
"#endif" "\n"


#define DEFPARAM(def, param)	""\
"#ifndef " #def "\n"\
	"#  define " #def "\t" #param "\n"\
"#endif" "\n"

#define WRITE_NL()		file.Write("\n", _tcslen("\n"), 1)



int iris_main(void)
{
	TCHAR out_path[MAX_PATH] = IRIS_TEXT("./prefix.h");
	TCHAR buf[4096];
	for( int i=1; i < ::__argc; ++i )
	{
		if( ::__argv[i][0] == '-' && ::__argv[i][1] != '\0' && ::__argv[i][2] == '\0' )
		{
			switch( ::__argv[i][1] )
			{
			case 'o':
				_tcscpy_s(out_path, MAX_PATH, ::__argv[++i]);
				goto file_open;
			case 'h':
				goto help;
			}
		}
	}

file_open:
	{
		CVersionInfo vi;
		if( !vi.Open() ) return 1;

		CFile file;
		if( !file.Open(out_path, IRIS_TEXT("wb")) ) return 1;
		printf("Create %s\n", out_path);

		TCHAR* fname = PathFindFileName(out_path);
		TCHAR* ext = PathFindExtension(fname);
		if( ext != nullptr ) *ext++ = '\0';
		TCHAR* exename;
		TCHAR* version;
		vi.GetOriginalFileName(&exename);
		vi.GetFileVersion(&version);
		wsprintf(buf, IRIS_TEXT(COMMENT), COMMENT_ARG(fname, ext, exename, version));
		file.Write(buf, _tcslen(buf), 1);

		// WINVER
		COSVersionInfo osvi;
		if( osvi.IsValid() )
		{
			u32 ver = (osvi->dwMajorVersion << 8) | (osvi->dwMinorVersion);
			wsprintf(buf, WINNT, ver);
			file.Write(buf, _tcslen(buf), 1);
			puts("_WIN32_WINNT");
		}

		// Windows Driver Kit
		{
			cpp0x::tr1::regex reg("Microsoft Windows Driver Kit");
			if( CInstallRegistry::IsInstall(CRegexSearchOp<>(), reg) )
			{
				wsprintf(buf, DEFINE(_IRIS_SUPPORT_WDK));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_SUPPORT_WDK");
			}
		}


		CCSIDLPath pgdir(CSIDL_PROGRAM_FILES);
		CPath path;
		TCHAR env[MAX_PATH];
		// Cg
		{
			if( GetEnvironmentVariable(IRIS_TEXT("CG_INC_PATH"), env, sizeof(env)) != 0 )
			{
				wsprintf(buf, DEFINE(_IRIS_SUPPORT_CG));
				file.Write(buf, _tcslen(buf), 1);
				// glut 
				wsprintf(buf, DEFINE(_IRIS_SUPPORT_GLUT));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_SUPPORT_CG");
				puts("_IRIS_SUPPORT_GLUT");
			}
		}
		// fbx
		{
			cpp0x::tr1::regex reg("Autodesk FBX SDK [0-9].*");
			if( CInstallRegistry::IsInstall(CRegexSearchOp<>(), reg) )
			{
				wsprintf(buf, DEFPARAM(_IRIS_SUPPORT_FBX, IRIS_UNKOWN_LIB));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_SUPPORT_FBX");
			}
		}
		// OpenAL 1.1
		{
			cpp0x::tr1::regex reg("OpenAL [0-9].*?.[0-9].*? Core PC SDK");
			if( CInstallRegistry::IsInstall(CRegexSearchOp<>(), reg) )
			{
				wsprintf(buf, DEFINE(_IRIS_SUPPORT_OPENAL));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_SUPPORT_OPENAL");
			}
		}

		WRITE_NL();

		// HTML HELP WORKSHOP
		{
			if( CInstallRegistry::IsInstall(IRIS_TEXT("HTML Help Workshop")) )
			{
				wsprintf(buf, DEFINE(_IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP");
			}
			else
			{
				path = pgdir;
				path.AddFileName("HTML Help Workshop\\include");
				if( path.FileExists() )
				{
					wsprintf(buf, DEFINE(_IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP));
					file.Write(buf, _tcslen(buf), 1);
					puts("_IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP");
				}
			}
		}

		WRITE_NL();
		WRITE_NL();

		// user define
		for( int i=1; i+1 < ::__argc; ++i )
		{
			if( ::__argv[i][0] == '-' && ::__argv[i][1] != '\0' && ::__argv[i][2] == '\0' )
			{
				switch( ::__argv[i][1] )
				{
				case 'D':
					{
						TCHAR n[512];
						LPTSTR cur;
						_tcscpy_s(n, IRIS_NumOfElements(n), ::__argv[++i]);
						LPTSTR p = _tcstok_s(n, "=", &cur);
						if( p == nullptr )
						{
							wsprintf(buf, "#define %s	", n);
						}
						else
						{
							LPTSTR v = _tcstok_s(nullptr, "=", &cur);
							wsprintf(buf, "#define %s	%s", p, v);
						}
						file.Write(buf, _tcslen(buf), 1);
					}
					break;
				}
			}
		}

		wsprintf(buf, IRIS_TEXT(END));
		file.Write(buf, _tcslen(buf), 1);

		return 0;
	}

help:
	{
		puts("iris_prefix_optimize help");
		puts("-h        : show help.");
		puts("-o [path] : output path set.");
		puts("-D [def=v]: user define set. def = name, v = value.");
		puts("            \'v\' can be omitted. ");
	}
	return 0;
}
