//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALError.cpp
 * @brief		OpenAL Error t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXALError_CPP_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "AXALError.h"
#if		defined(_WIN32)
#include <al.h>
#include <alc.h>
#elif	(defined(TARGET_OS_MAC) && TARGET_OS_MAC)
#include <OpenAL/al.h>
#include <OpenAL/alc.h>
#endif

//======================================================================
// define
#define TEXTA(t)	t
#define TEXTW(t)	L##t

#define _AXAL_SWITCH_ERROR_MESSAGE(func, text)				\
	switch( Error )											\
	{														\
	case AL_NO_ERROR:										\
		func(lpBuf, size, text("AL_NO_ERROR"));				\
		break;												\
															\
	case AL_INVALID_NAME:									\
		func(lpBuf, size, text("AL_INVALID_NAME"));			\
		break;												\
	case AL_INVALID_ENUM:									\
		func(lpBuf, size, text("AL_INVALID_ENUM"));			\
		break;												\
	case AL_INVALID_VALUE:									\
		func(lpBuf, size, text("AL_INVALID_VALUE"));		\
		break;												\
	case AL_INVALID_OPERATION:								\
		func(lpBuf, size, text("AL_INVALID_OPERATION"));	\
		break;												\
	case AL_OUT_OF_MEMORY:									\
		func(lpBuf, size, text("AL_OUT_OF_MEMORY"));		\
		break;												\
}

#define _AXALC_SWITCH_ERROR_MESSAGE(func, text)				\
	switch( Error )											\
	{														\
	case ALC_NO_ERROR:										\
		func(lpBuf, size, text("ALC_NO_ERROR"));			\
		break;												\
															\
	case ALC_INVALID_DEVICE:								\
		func(lpBuf, size, text("ALC_INVALID_DEVICE"));		\
		break;												\
	case ALC_INVALID_CONTEXT:								\
		func(lpBuf, size, text("ALC_INVALID_CONTEXT"));		\
		break;												\
	case ALC_INVALID_ENUM:									\
		func(lpBuf, size, text("ALC_INVALID_ENUM"));		\
		break;												\
	case ALC_INVALID_VALUE:									\
		func(lpBuf, size, text("ALC_INVALID_VALUE"));		\
		break;												\
	case ALC_OUT_OF_MEMORY:									\
		func(lpBuf, size, text("ALC_OUT_OF_MEMORY"));		\
		break;												\
}

namespace iris {
namespace ax {
namespace al
{

/**********************************************************************//**
 *
 * G[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	Error	= G[l
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
void	AXALFormatMessage (int Error, LPTSTR lpBuf, size_t size)
{
#ifdef UNICODE
	AXALFormatMessageW(Error, lpBuf, size);
#else
	AXALFormatMessageA(Error, lpBuf, size);
#endif
}
/**
 * @ref	AXALFormatMessage
*/
void	AXALFormatMessageA(int Error, LPSTR  lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_AXAL_SWITCH_ERROR_MESSAGE(strcpy_s, TEXTA);
}
/**
 * @ref	AXALFormatMessage
*/
void	AXALFormatMessageW(int Error, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_AXAL_SWITCH_ERROR_MESSAGE(wcscpy_s, TEXTW);
}

/**********************************************************************//**
 *
 * G[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	Error	= G[l
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
void	AXALCFormatMessage (int Error, LPTSTR lpBuf, size_t size)
{
#ifdef UNICODE
	AXALCFormatMessageW(Error, lpBuf, size);
#else
	AXALCFormatMessageA(Error, lpBuf, size);
#endif
}
/**
 * @ref	AXALCFormatMessage
*/
void	AXALCFormatMessageA(int Error, LPSTR  lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_AXALC_SWITCH_ERROR_MESSAGE(strcpy_s, TEXTA);
}
/**
 * @ref	AXALCFormatMessage
*/
void	AXALCFormatMessageW(int Error, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_AXALC_SWITCH_ERROR_MESSAGE(wcscpy_s, TEXTW);
}

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif

