//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALError.h
 * @brief		OpenAL Errort@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXALError_H_
#define INCG_IRIS_AXALError_H_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "../../iris_inchead.h"
#include "../../iris_debug.h"
#include "AXALTypes.h"

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// function
void	AXALFormatMessage (int Error, LPTSTR lpBuf, size_t size);
void	AXALFormatMessageA(int Error, LPSTR  lpBuf, size_t size);
void	AXALFormatMessageW(int Error, LPWSTR lpBuf, size_t size);

void	AXALCFormatMessage (int Error, LPTSTR lpBuf, size_t size);
void	AXALCFormatMessageA(int Error, LPSTR  lpBuf, size_t size);
void	AXALCFormatMessageW(int Error, LPWSTR lpBuf, size_t size);

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

//======================================================================
// define
#define AXAL_SUCCEEDED(result)			(result == AL_NO_ERROR)
#define AXAL_FAILED(result)				(result != AL_NO_ERROR)

#ifdef _IRIS_DEBUG

#define AXAL_ERROR(Error)				do { if( AXAL_FAILED(Error) ) { TCHAR err_str[256]; iris::ax::al::AXALFormatMessage(Error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :<%s>.\n")  , __LINE__, err_str); } } while(0)
#define AXAL_ERROR2(Error, comm)		do { if( AXAL_FAILED(Error) ) { TCHAR err_str[256]; iris::ax::al::AXALFormatMessage(Error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:<%s>.\n"), __LINE__, comm, err_str); } } while(0)
#define AXAL_CHECK_RESULT(exp)			do { AXALENUM Error = (exp); if( AXAL_FAILED(Error) ) {				\
											TCHAR err_str[256]; iris::ax::al::AXALFormatMessage(Error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
										} } while(0)
#define AXAL_DO_CHECK_RESULT(exp, todo)	do { AXALENUM Error = (exp); if( AXAL_FAILED(Error) ) {				\
											TCHAR err_str[256]; iris::ax::al::AXALFormatMessage(Error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
											todo;														\
										} } while(0)

#else

#define AXAL_ERROR(Error)				(void)(0)
#define AXAL_ERROR2(Error, comm)		(void)(0)
#define AXAL_CHECK_RESULT(exp)			exp
#define AXAL_DO_CHECK_RESULT(exp, todo)	do { if( AXAL_FAILED(exp) ) { todo; } } while(0)

#endif


#define AXALC_SUCCEEDED(result)				(result == ALC_NO_ERROR)
#define AXALC_FAILED(result)				(result != ALC_NO_ERROR)

#ifdef _IRIS_DEBUG

#define AXALC_ERROR(Error)					do { if( AXALC_FAILED(Error) ) { TCHAR err_str[256]; iris::ax::al::AXALCFormatMessage(Error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :<%s>.\n")  , __LINE__, err_str); } } while(0)
#define AXALC_ERROR2(Error, comm)			do { if( AXALC_FAILED(Error) ) { TCHAR err_str[256]; iris::ax::al::AXALCFormatMessage(Error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:<%s>.\n"), __LINE__, comm, err_str); } } while(0)
#define AXALC_CHECK_RESULT(exp)				do { int Error = (exp); if( AXALC_FAILED(Error) ) {				\
											TCHAR err_str[256]; iris::ax::al::AXALCFormatMessage(Error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
											} } while(0)
#define AXALC_DO_CHECK_RESULT(exp, todo)	do { int Error = (exp); if( AXALC_FAILED(Error) ) {				\
											TCHAR err_str[256]; iris::ax::al::AXALCFormatMessage(Error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
											todo;														\
											} } while(0)

#else

#define AXALC_ERROR(Error)					(void)(0)
#define AXALC_ERROR2(Error, comm)			(void)(0)
#define AXALC_CHECK_RESULT(exp)				exp
#define AXALC_DO_CHECK_RESULT(exp, todo)	do { if( AXALC_FAILED(exp) ) { todo; } } while(0)

#endif

#endif

#endif
